/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.SSESpecification;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SSESpecificationMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<String> SSETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SSEType").isBinary(false).build();
    private static final MarshallingInfo<String> KMSMASTERKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KMSMasterKeyId").isBinary(false).build();
    private static final SSESpecificationMarshaller INSTANCE = new SSESpecificationMarshaller();

    private SSESpecificationMarshaller() {
    }

    public static SSESpecificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SSESpecification sseSpecification, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sseSpecification, (String)"sseSpecification");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sseSpecification.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)sseSpecification.sseTypeAsString(), SSETYPE_BINDING);
            protocolMarshaller.marshall((Object)sseSpecification.kmsMasterKeyId(), KMSMASTERKEYID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

