/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AutoScalingSettingsDescriptionMarshaller {
    private static final MarshallingInfo<Long> MINIMUMUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinimumUnits").isBinary(false).build();
    private static final MarshallingInfo<Long> MAXIMUMUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumUnits").isBinary(false).build();
    private static final MarshallingInfo<Boolean> AUTOSCALINGDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingDisabled").isBinary(false).build();
    private static final MarshallingInfo<String> AUTOSCALINGROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingRoleArn").isBinary(false).build();
    private static final MarshallingInfo<List> SCALINGPOLICIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScalingPolicies").isBinary(false).build();
    private static final AutoScalingSettingsDescriptionMarshaller INSTANCE = new AutoScalingSettingsDescriptionMarshaller();

    private AutoScalingSettingsDescriptionMarshaller() {
    }

    public static AutoScalingSettingsDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AutoScalingSettingsDescription autoScalingSettingsDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)autoScalingSettingsDescription, (String)"autoScalingSettingsDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)autoScalingSettingsDescription.minimumUnits(), MINIMUMUNITS_BINDING);
            protocolMarshaller.marshall((Object)autoScalingSettingsDescription.maximumUnits(), MAXIMUMUNITS_BINDING);
            protocolMarshaller.marshall((Object)autoScalingSettingsDescription.autoScalingDisabled(), AUTOSCALINGDISABLED_BINDING);
            protocolMarshaller.marshall((Object)autoScalingSettingsDescription.autoScalingRoleArn(), AUTOSCALINGROLEARN_BINDING);
            protocolMarshaller.marshall(autoScalingSettingsDescription.scalingPolicies(), SCALINGPOLICIES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

