/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.SSEType;
import software.amazon.awssdk.services.dynamodb.transform.SSESpecificationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SSESpecification
implements StructuredPojo,
ToCopyableBuilder<Builder, SSESpecification> {
    private final Boolean enabled;
    private final String sseType;
    private final String kmsMasterKeyId;

    private SSESpecification(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.sseType = builder.sseType;
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public SSEType sseType() {
        return SSEType.fromValue(this.sseType);
    }

    public String sseTypeAsString() {
        return this.sseType;
    }

    public String kmsMasterKeyId() {
        return this.kmsMasterKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsMasterKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSESpecification)) {
            return false;
        }
        SSESpecification other = (SSESpecification)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.sseTypeAsString(), other.sseTypeAsString()) && Objects.equals(this.kmsMasterKeyId(), other.kmsMasterKeyId());
    }

    public String toString() {
        return ToString.builder((String)"SSESpecification").add("Enabled", (Object)this.enabled()).add("SSEType", (Object)this.sseTypeAsString()).add("KMSMasterKeyId", (Object)this.kmsMasterKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "SSEType": {
                return Optional.ofNullable(clazz.cast(this.sseTypeAsString()));
            }
            case "KMSMasterKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsMasterKeyId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SSESpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String sseType;
        private String kmsMasterKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(SSESpecification model) {
            this.enabled(model.enabled);
            this.sseType(model.sseType);
            this.kmsMasterKeyId(model.kmsMasterKeyId);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getSSEType() {
            return this.sseType;
        }

        @Override
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        @Override
        public final Builder sseType(SSEType sseType) {
            this.sseType(sseType.toString());
            return this;
        }

        public final void setSSEType(String sseType) {
            this.sseType = sseType;
        }

        public final String getKMSMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final void setKMSMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        public SSESpecification build() {
            return new SSESpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SSESpecification> {
        public Builder enabled(Boolean var1);

        public Builder sseType(String var1);

        public Builder sseType(SSEType var1);

        public Builder kmsMasterKeyId(String var1);
    }
}

