/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.SSEStatus;
import software.amazon.awssdk.services.dynamodb.model.SSEType;
import software.amazon.awssdk.services.dynamodb.transform.SSEDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SSEDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, SSEDescription> {
    private final String status;
    private final String sseType;
    private final String kmsMasterKeyArn;

    private SSEDescription(BuilderImpl builder) {
        this.status = builder.status;
        this.sseType = builder.sseType;
        this.kmsMasterKeyArn = builder.kmsMasterKeyArn;
    }

    public SSEStatus status() {
        return SSEStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public SSEType sseType() {
        return SSEType.fromValue(this.sseType);
    }

    public String sseTypeAsString() {
        return this.sseType;
    }

    public String kmsMasterKeyArn() {
        return this.kmsMasterKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsMasterKeyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSEDescription)) {
            return false;
        }
        SSEDescription other = (SSEDescription)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sseTypeAsString(), other.sseTypeAsString()) && Objects.equals(this.kmsMasterKeyArn(), other.kmsMasterKeyArn());
    }

    public String toString() {
        return ToString.builder((String)"SSEDescription").add("Status", (Object)this.statusAsString()).add("SSEType", (Object)this.sseTypeAsString()).add("KMSMasterKeyArn", (Object)this.kmsMasterKeyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SSEType": {
                return Optional.ofNullable(clazz.cast(this.sseTypeAsString()));
            }
            case "KMSMasterKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsMasterKeyArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SSEDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String sseType;
        private String kmsMasterKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SSEDescription model) {
            this.status(model.status);
            this.sseType(model.sseType);
            this.kmsMasterKeyArn(model.kmsMasterKeyArn);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SSEStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSSEType() {
            return this.sseType;
        }

        @Override
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        @Override
        public final Builder sseType(SSEType sseType) {
            this.sseType(sseType.toString());
            return this;
        }

        public final void setSSEType(String sseType) {
            this.sseType = sseType;
        }

        public final String getKMSMasterKeyArn() {
            return this.kmsMasterKeyArn;
        }

        @Override
        public final Builder kmsMasterKeyArn(String kmsMasterKeyArn) {
            this.kmsMasterKeyArn = kmsMasterKeyArn;
            return this;
        }

        public final void setKMSMasterKeyArn(String kmsMasterKeyArn) {
            this.kmsMasterKeyArn = kmsMasterKeyArn;
        }

        public SSEDescription build() {
            return new SSEDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SSEDescription> {
        public Builder status(String var1);

        public Builder status(SSEStatus var1);

        public Builder sseType(String var1);

        public Builder sseType(SSEType var1);

        public Builder kmsMasterKeyArn(String var1);
    }
}

