/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableDescription;
import software.amazon.awssdk.services.dynamodb.transform.ReplicaDescriptionUnmarshaller;

public class GlobalTableDescriptionUnmarshaller
implements Unmarshaller<GlobalTableDescription, JsonUnmarshallerContext> {
    private static final GlobalTableDescriptionUnmarshaller INSTANCE = new GlobalTableDescriptionUnmarshaller();

    public GlobalTableDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        GlobalTableDescription.Builder globalTableDescriptionBuilder = GlobalTableDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ReplicationGroup", targetDepth)) {
                    context.nextToken();
                    globalTableDescriptionBuilder.replicationGroup(new ListUnmarshaller((Unmarshaller)ReplicaDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("GlobalTableArn", targetDepth)) {
                    context.nextToken();
                    globalTableDescriptionBuilder.globalTableArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationDateTime", targetDepth)) {
                    context.nextToken();
                    globalTableDescriptionBuilder.creationDateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("GlobalTableStatus", targetDepth)) {
                    context.nextToken();
                    globalTableDescriptionBuilder.globalTableStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("GlobalTableName", targetDepth)) {
                    context.nextToken();
                    globalTableDescriptionBuilder.globalTableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (GlobalTableDescription)globalTableDescriptionBuilder.build();
    }

    public static GlobalTableDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

