/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodbstreams;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.StaticSignerProvider;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.awscore.config.defaults.AwsClientConfigurationDefaults;
import software.amazon.awssdk.awscore.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.core.runtime.auth.Signer;
import software.amazon.awssdk.core.runtime.auth.SignerProvider;
import software.amazon.awssdk.services.dynamodbstreams.DynamoDBStreamsBaseClientBuilder;

@SdkInternalApi
abstract class DefaultDynamoDBStreamsBaseClientBuilder<B extends DynamoDBStreamsBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultDynamoDBStreamsBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "streams.dynamodb";
    }

    protected final AwsClientConfigurationDefaults serviceDefaults() {
        return ServiceBuilderConfigurationDefaults.builder().defaultSignerProvider(this::defaultSignerProvider).addRequestHandlerPath("software/amazon/awssdk/services/dynamodbstreams/execution.interceptors").crc32FromCompressedDataEnabled(Boolean.valueOf(false)).build();
    }

    private SignerProvider defaultSignerProvider() {
        Aws4Signer signer = new Aws4Signer();
        signer.setServiceName("dynamodb");
        signer.setRegionName(this.signingRegion().value());
        return StaticSignerProvider.create((Signer)signer);
    }
}

