/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class QueryRequestModelMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<String> INDEXNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexName").isBinary(false).build();
    private static final MarshallingInfo<String> SELECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Select").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTESTOGET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributesToGet").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CONSISTENTREAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsistentRead").isBinary(false).build();
    private static final MarshallingInfo<Map> KEYCONDITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyConditions").isBinary(false).build();
    private static final MarshallingInfo<Map> QUERYFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryFilter").isBinary(false).build();
    private static final MarshallingInfo<String> CONDITIONALOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConditionalOperator").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SCANINDEXFORWARD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScanIndexForward").isBinary(false).build();
    private static final MarshallingInfo<Map> EXCLUSIVESTARTKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExclusiveStartKey").isBinary(false).build();
    private static final MarshallingInfo<String> RETURNCONSUMEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnConsumedCapacity").isBinary(false).build();
    private static final MarshallingInfo<String> PROJECTIONEXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProjectionExpression").isBinary(false).build();
    private static final MarshallingInfo<String> FILTEREXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FilterExpression").isBinary(false).build();
    private static final MarshallingInfo<String> KEYCONDITIONEXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyConditionExpression").isBinary(false).build();
    private static final MarshallingInfo<Map> EXPRESSIONATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpressionAttributeNames").isBinary(false).build();
    private static final MarshallingInfo<Map> EXPRESSIONATTRIBUTEVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpressionAttributeValues").isBinary(false).build();
    private static final QueryRequestModelMarshaller INSTANCE = new QueryRequestModelMarshaller();

    private QueryRequestModelMarshaller() {
    }

    public static QueryRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(QueryRequest queryRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)queryRequest), (String)"queryRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)queryRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)queryRequest.indexName(), INDEXNAME_BINDING);
            protocolMarshaller.marshall((Object)queryRequest.selectAsString(), SELECT_BINDING);
            protocolMarshaller.marshall(queryRequest.attributesToGet(), ATTRIBUTESTOGET_BINDING);
            protocolMarshaller.marshall((Object)queryRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)queryRequest.consistentRead(), CONSISTENTREAD_BINDING);
            protocolMarshaller.marshall(queryRequest.keyConditions(), KEYCONDITIONS_BINDING);
            protocolMarshaller.marshall(queryRequest.queryFilter(), QUERYFILTER_BINDING);
            protocolMarshaller.marshall((Object)queryRequest.conditionalOperatorAsString(), CONDITIONALOPERATOR_BINDING);
            protocolMarshaller.marshall((Object)queryRequest.scanIndexForward(), SCANINDEXFORWARD_BINDING);
            protocolMarshaller.marshall(queryRequest.exclusiveStartKey(), EXCLUSIVESTARTKEY_BINDING);
            protocolMarshaller.marshall((Object)queryRequest.returnConsumedCapacityAsString(), RETURNCONSUMEDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)queryRequest.projectionExpression(), PROJECTIONEXPRESSION_BINDING);
            protocolMarshaller.marshall((Object)queryRequest.filterExpression(), FILTEREXPRESSION_BINDING);
            protocolMarshaller.marshall((Object)queryRequest.keyConditionExpression(), KEYCONDITIONEXPRESSION_BINDING);
            protocolMarshaller.marshall(queryRequest.expressionAttributeNames(), EXPRESSIONATTRIBUTENAMES_BINDING);
            protocolMarshaller.marshall(queryRequest.expressionAttributeValues(), EXPRESSIONATTRIBUTEVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

