/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.services.dynamodb.transform.StreamSpecificationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StreamSpecification
implements StructuredPojo,
ToCopyableBuilder<Builder, StreamSpecification> {
    private final Boolean streamEnabled;
    private final String streamViewType;

    private StreamSpecification(BuilderImpl builder) {
        this.streamEnabled = builder.streamEnabled;
        this.streamViewType = builder.streamViewType;
    }

    public Boolean streamEnabled() {
        return this.streamEnabled;
    }

    public StreamViewType streamViewType() {
        return StreamViewType.fromValue(this.streamViewType);
    }

    public String streamViewTypeAsString() {
        return this.streamViewType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamViewTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSpecification)) {
            return false;
        }
        StreamSpecification other = (StreamSpecification)obj;
        return Objects.equals(this.streamEnabled(), other.streamEnabled()) && Objects.equals(this.streamViewTypeAsString(), other.streamViewTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"StreamSpecification").add("StreamEnabled", (Object)this.streamEnabled()).add("StreamViewType", (Object)this.streamViewTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamEnabled": {
                return Optional.of(clazz.cast(this.streamEnabled()));
            }
            case "StreamViewType": {
                return Optional.of(clazz.cast(this.streamViewTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean streamEnabled;
        private String streamViewType;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSpecification model) {
            this.streamEnabled(model.streamEnabled);
            this.streamViewType(model.streamViewType);
        }

        public final Boolean getStreamEnabled() {
            return this.streamEnabled;
        }

        @Override
        public final Builder streamEnabled(Boolean streamEnabled) {
            this.streamEnabled = streamEnabled;
            return this;
        }

        public final void setStreamEnabled(Boolean streamEnabled) {
            this.streamEnabled = streamEnabled;
        }

        public final String getStreamViewType() {
            return this.streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType.toString());
            return this;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        public StreamSpecification build() {
            return new StreamSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamSpecification> {
        public Builder streamEnabled(Boolean var1);

        public Builder streamViewType(String var1);

        public Builder streamViewType(StreamViewType var1);
    }
}

