/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;

@SdkInternalApi
public class AttributeValueUpdateMarshaller {
    private static final MarshallingInfo<StructuredPojo> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final AttributeValueUpdateMarshaller instance = new AttributeValueUpdateMarshaller();

    public static AttributeValueUpdateMarshaller getInstance() {
        return instance;
    }

    public void marshall(AttributeValueUpdate attributeValueUpdate, ProtocolMarshaller protocolMarshaller) {
        if (attributeValueUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)attributeValueUpdate.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)attributeValueUpdate.action(), ACTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

