/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinitionsCopier;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdateListCopier;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateTableRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateTableRequest> {
    private final List<AttributeDefinition> attributeDefinitions;
    private final String tableName;
    private final ProvisionedThroughput provisionedThroughput;
    private final List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates;
    private final StreamSpecification streamSpecification;

    private UpdateTableRequest(BuilderImpl builder) {
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.globalSecondaryIndexUpdates = builder.globalSecondaryIndexUpdates;
        this.streamSpecification = builder.streamSpecification;
    }

    public List<AttributeDefinition> attributeDefinitions() {
        return this.attributeDefinitions;
    }

    public String tableName() {
        return this.tableName;
    }

    public ProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates() {
        return this.globalSecondaryIndexUpdates;
    }

    public StreamSpecification streamSpecification() {
        return this.streamSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributeDefinitions() == null ? 0 : this.attributeDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.provisionedThroughput() == null ? 0 : this.provisionedThroughput().hashCode());
        hashCode = 31 * hashCode + (this.globalSecondaryIndexUpdates() == null ? 0 : this.globalSecondaryIndexUpdates().hashCode());
        hashCode = 31 * hashCode + (this.streamSpecification() == null ? 0 : this.streamSpecification().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest)((Object)obj);
        if (other.attributeDefinitions() == null ^ this.attributeDefinitions() == null) {
            return false;
        }
        if (other.attributeDefinitions() != null && !other.attributeDefinitions().equals(this.attributeDefinitions())) {
            return false;
        }
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.provisionedThroughput() == null ^ this.provisionedThroughput() == null) {
            return false;
        }
        if (other.provisionedThroughput() != null && !other.provisionedThroughput().equals(this.provisionedThroughput())) {
            return false;
        }
        if (other.globalSecondaryIndexUpdates() == null ^ this.globalSecondaryIndexUpdates() == null) {
            return false;
        }
        if (other.globalSecondaryIndexUpdates() != null && !other.globalSecondaryIndexUpdates().equals(this.globalSecondaryIndexUpdates())) {
            return false;
        }
        if (other.streamSpecification() == null ^ this.streamSpecification() == null) {
            return false;
        }
        return other.streamSpecification() == null || other.streamSpecification().equals(this.streamSpecification());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributeDefinitions() != null) {
            sb.append("AttributeDefinitions: ").append(this.attributeDefinitions()).append(",");
        }
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.provisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: ").append(this.provisionedThroughput()).append(",");
        }
        if (this.globalSecondaryIndexUpdates() != null) {
            sb.append("GlobalSecondaryIndexUpdates: ").append(this.globalSecondaryIndexUpdates()).append(",");
        }
        if (this.streamSpecification() != null) {
            sb.append("StreamSpecification: ").append(this.streamSpecification()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AttributeDefinition> attributeDefinitions;
        private String tableName;
        private ProvisionedThroughput provisionedThroughput;
        private List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates;
        private StreamSpecification streamSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableRequest model) {
            this.setAttributeDefinitions(model.attributeDefinitions);
            this.setTableName(model.tableName);
            this.setProvisionedThroughput(model.provisionedThroughput);
            this.setGlobalSecondaryIndexUpdates(model.globalSecondaryIndexUpdates);
            this.setStreamSpecification(model.streamSpecification);
        }

        public final Collection<AttributeDefinition> getAttributeDefinitions() {
            return this.attributeDefinitions;
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition ... attributeDefinitions) {
            if (this.attributeDefinitions == null) {
                this.attributeDefinitions = new ArrayList<AttributeDefinition>(attributeDefinitions.length);
            }
            for (AttributeDefinition e : attributeDefinitions) {
                this.attributeDefinitions.add(e);
            }
            return this;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
        }

        @SafeVarargs
        public final void setAttributeDefinitions(AttributeDefinition ... attributeDefinitions) {
            if (this.attributeDefinitions == null) {
                this.attributeDefinitions = new ArrayList<AttributeDefinition>(attributeDefinitions.length);
            }
            for (AttributeDefinition e : attributeDefinitions) {
                this.attributeDefinitions.add(e);
            }
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final ProvisionedThroughput getProvisionedThroughput() {
            return this.provisionedThroughput;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
        }

        public final Collection<GlobalSecondaryIndexUpdate> getGlobalSecondaryIndexUpdates() {
            return this.globalSecondaryIndexUpdates;
        }

        @Override
        public final Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexUpdateListCopier.copy(globalSecondaryIndexUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate ... globalSecondaryIndexUpdates) {
            if (this.globalSecondaryIndexUpdates == null) {
                this.globalSecondaryIndexUpdates = new ArrayList<GlobalSecondaryIndexUpdate>(globalSecondaryIndexUpdates.length);
            }
            for (GlobalSecondaryIndexUpdate e : globalSecondaryIndexUpdates) {
                this.globalSecondaryIndexUpdates.add(e);
            }
            return this;
        }

        public final void setGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexUpdateListCopier.copy(globalSecondaryIndexUpdates);
        }

        @SafeVarargs
        public final void setGlobalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate ... globalSecondaryIndexUpdates) {
            if (this.globalSecondaryIndexUpdates == null) {
                this.globalSecondaryIndexUpdates = new ArrayList<GlobalSecondaryIndexUpdate>(globalSecondaryIndexUpdates.length);
            }
            for (GlobalSecondaryIndexUpdate e : globalSecondaryIndexUpdates) {
                this.globalSecondaryIndexUpdates.add(e);
            }
        }

        public final StreamSpecification getStreamSpecification() {
            return this.streamSpecification;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final void setStreamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
        }

        public UpdateTableRequest build() {
            return new UpdateTableRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateTableRequest> {
        public Builder attributeDefinitions(Collection<AttributeDefinition> var1);

        public Builder attributeDefinitions(AttributeDefinition ... var1);

        public Builder tableName(String var1);

        public Builder provisionedThroughput(ProvisionedThroughput var1);

        public Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> var1);

        public Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate ... var1);

        public Builder streamSpecification(StreamSpecification var1);
    }
}

