/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.transform.LocalSecondaryIndexMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LocalSecondaryIndex
implements StructuredPojo,
ToCopyableBuilder<Builder, LocalSecondaryIndex> {
    private final String indexName;
    private final List<KeySchemaElement> keySchema;
    private final Projection projection;

    private LocalSecondaryIndex(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.keySchema = builder.keySchema;
        this.projection = builder.projection;
    }

    public String indexName() {
        return this.indexName;
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public Projection projection() {
        return this.projection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.indexName() == null ? 0 : this.indexName().hashCode());
        hashCode = 31 * hashCode + (this.keySchema() == null ? 0 : this.keySchema().hashCode());
        hashCode = 31 * hashCode + (this.projection() == null ? 0 : this.projection().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalSecondaryIndex)) {
            return false;
        }
        LocalSecondaryIndex other = (LocalSecondaryIndex)obj;
        if (other.indexName() == null ^ this.indexName() == null) {
            return false;
        }
        if (other.indexName() != null && !other.indexName().equals(this.indexName())) {
            return false;
        }
        if (other.keySchema() == null ^ this.keySchema() == null) {
            return false;
        }
        if (other.keySchema() != null && !other.keySchema().equals(this.keySchema())) {
            return false;
        }
        if (other.projection() == null ^ this.projection() == null) {
            return false;
        }
        return other.projection() == null || other.projection().equals(this.projection());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.indexName() != null) {
            sb.append("IndexName: ").append(this.indexName()).append(",");
        }
        if (this.keySchema() != null) {
            sb.append("KeySchema: ").append(this.keySchema()).append(",");
        }
        if (this.projection() != null) {
            sb.append("Projection: ").append(this.projection()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocalSecondaryIndexMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String indexName;
        private List<KeySchemaElement> keySchema;
        private Projection projection;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalSecondaryIndex model) {
            this.setIndexName(model.indexName);
            this.setKeySchema(model.keySchema);
            this.setProjection(model.projection);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Collection<KeySchemaElement> getKeySchema() {
            return this.keySchema;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            if (this.keySchema == null) {
                this.keySchema = new ArrayList<KeySchemaElement>(keySchema.length);
            }
            for (KeySchemaElement e : keySchema) {
                this.keySchema.add(e);
            }
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
        }

        @SafeVarargs
        public final void setKeySchema(KeySchemaElement ... keySchema) {
            if (this.keySchema == null) {
                this.keySchema = new ArrayList<KeySchemaElement>(keySchema.length);
            }
            for (KeySchemaElement e : keySchema) {
                this.keySchema.add(e);
            }
        }

        public final Projection getProjection() {
            return this.projection;
        }

        @Override
        public final Builder projection(Projection projection) {
            this.projection = projection;
            return this;
        }

        public final void setProjection(Projection projection) {
            this.projection = projection;
        }

        public LocalSecondaryIndex build() {
            return new LocalSecondaryIndex(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LocalSecondaryIndex> {
        public Builder indexName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder projection(Projection var1);
    }
}

