/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document;

import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;

public class Expected {
    private final String attribute;
    private ComparisonOperator op;
    private Object[] values;

    public Expected(String attrName) {
        InternalUtils.checkInvalidAttrName(attrName);
        this.attribute = attrName;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public ComparisonOperator getComparisonOperator() {
        return this.op;
    }

    public Object[] values() {
        return this.values == null ? null : (Object[])this.values.clone();
    }

    private Expected values(Object ... values) {
        this.values = (Object[])values.clone();
        return this;
    }

    private Expected withComparisonOperator(ComparisonOperator op) {
        this.op = op;
        return this;
    }

    public Expected eq(Object val) {
        return this.withComparisonOperator(ComparisonOperator.EQ).values(val);
    }

    public Expected ne(Object val) {
        return this.withComparisonOperator(ComparisonOperator.NE).values(val);
    }

    public Expected exists() {
        return this.withComparisonOperator(ComparisonOperator.NOT_NULL);
    }

    public Expected notExist() {
        return this.withComparisonOperator(ComparisonOperator.NULL);
    }

    public Expected contains(Object val) {
        return this.withComparisonOperator(ComparisonOperator.CONTAINS).values(val);
    }

    public Expected notContains(Object val) {
        return this.withComparisonOperator(ComparisonOperator.NOT_CONTAINS).values(val);
    }

    public Expected beginsWith(String val) {
        return this.withComparisonOperator(ComparisonOperator.BEGINS_WITH).values(val);
    }

    public Expected in(Object ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("values must not be null or empty.");
        }
        return this.withComparisonOperator(ComparisonOperator.IN).values(values);
    }

    public Expected between(Object low, Object hi) {
        return this.withComparisonOperator(ComparisonOperator.BETWEEN).values(low, hi);
    }

    public Expected ge(Object val) {
        return this.withComparisonOperator(ComparisonOperator.GE).values(val);
    }

    public Expected gt(Object val) {
        return this.withComparisonOperator(ComparisonOperator.GT).values(val);
    }

    public Expected le(Object val) {
        return this.withComparisonOperator(ComparisonOperator.LE).values(val);
    }

    public Expected lt(Object val) {
        return this.withComparisonOperator(ComparisonOperator.LT).values(val);
    }
}

