/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers;

import java.text.ParseException;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.datamodeling.ItemConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.MUnmarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class ObjectUnmarshaller
extends MUnmarshaller {
    private static final ObjectUnmarshaller INSTANCE = new ObjectUnmarshaller();
    private final ItemConverter converter;
    private final Class<?> clazz;

    private ObjectUnmarshaller() {
        this.converter = null;
        this.clazz = null;
    }

    public ObjectUnmarshaller(ItemConverter converter, Class<?> clazz) {
        if (converter == null) {
            throw new NullPointerException("converter");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        this.converter = converter;
        this.clazz = clazz;
    }

    public static ObjectUnmarshaller instance() {
        return INSTANCE;
    }

    @Override
    public Object unmarshall(AttributeValue value) throws ParseException {
        Map<String, AttributeValue> map = value.m();
        return this.converter.unconvert(this.clazz, map);
    }
}

