/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDb;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAttribute;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerateStrategy;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerated;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerator;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbFlattened;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbHashKey;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbIgnore;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbIndexHashKey;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbIndexRangeKey;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbKeyed;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperFieldModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperTableModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbNamed;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbRangeKey;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbScalarAttribute;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTable;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverted;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTyped;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbVersionAttribute;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbVersioned;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardBeanProperties;
import software.amazon.awssdk.services.dynamodb.model.KeyType;

@SdkInternalApi
final class StandardAnnotationMaps {
    StandardAnnotationMaps() {
    }

    static final <T> TableMap<T> of(Class<T> clazz) {
        TableMap annotations = new TableMap(clazz);
        annotations.putAll(clazz);
        return annotations;
    }

    static final <T> FieldMap<T> of(Method getter, String defaultName) {
        Class<?> targetType = getter.getReturnType();
        String fieldName = StandardBeanProperties.fieldNameOf(getter);
        Field declaredField = null;
        try {
            declaredField = getter.getDeclaringClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException e) {
            throw new DynamoDbMappingException("no access to field for " + getter, e);
        }
        if (defaultName == null) {
            defaultName = fieldName;
        }
        FieldMap annotations = new FieldMap(targetType, defaultName);
        annotations.putAll(targetType);
        annotations.putAll(declaredField);
        annotations.putAll(getter);
        return annotations;
    }

    private static <T> T overrideOf(Class<T> clazz, Class<?> targetType, Annotation annotation) {
        try {
            if (annotation != null) {
                try {
                    Constructor<T> c = clazz.getConstructor(Class.class, annotation.annotationType());
                    return c.newInstance(targetType, annotation);
                }
                catch (NoSuchMethodException c) {
                    // empty catch block
                }
            }
            try {
                return clazz.getConstructor(Class.class).newInstance(targetType);
            }
            catch (NoSuchMethodException c) {
                return clazz.newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException | RuntimeException | InvocationTargetException e) {
            throw new DynamoDbMappingException("could not instantiate " + clazz, e);
        }
    }

    private static final class Annotations
    extends LinkedHashMap<Class<? extends Annotation>, Annotation> {
        private static final long serialVersionUID = -1L;

        private Annotations() {
        }

        public boolean putIfAnnotated(Class<? extends Annotation> annotationType, Annotation annotation) {
            if (!annotationType.isAnnotationPresent(DynamoDb.class)) {
                return false;
            }
            if ((annotation = this.put(annotationType, annotation)) == null) {
                return true;
            }
            throw new DynamoDbMappingException("conflicting annotations " + annotation + " and " + this.get(annotationType) + "; allowed only one of @" + annotationType.getSimpleName());
        }

        public Annotations putAll(Annotation ... annotations) {
            for (Annotation a1 : annotations) {
                this.putIfAnnotated(a1.annotationType(), a1);
                for (Annotation a2 : a1.annotationType().getAnnotations()) {
                    if (!this.putIfAnnotated(a2.annotationType(), a1)) continue;
                    for (Annotation a3 : a2.annotationType().getAnnotations()) {
                        this.putIfAnnotated(a3.annotationType(), a2);
                    }
                }
            }
            return this;
        }
    }

    static final class FieldMap<T>
    extends TypedMap<T>
    implements DynamoDbMapperFieldModel.Properties<T> {
        private final String defaultName;

        private FieldMap(Class<T> targetType, String defaultName) {
            super(targetType);
            this.defaultName = defaultName;
        }

        public boolean ignored() {
            return this.actualOf(DynamoDbIgnore.class) != null;
        }

        @Override
        public DynamoDbMapperFieldModel.DynamoDbAttributeType attributeType() {
            DynamoDbScalarAttribute annotation = this.actualOf(DynamoDbScalarAttribute.class);
            if (annotation != null) {
                if (Set.class.isAssignableFrom(this.targetType())) {
                    return DynamoDbMapperFieldModel.DynamoDbAttributeType.valueOf(annotation.type().name() + "S");
                }
                return DynamoDbMapperFieldModel.DynamoDbAttributeType.valueOf(annotation.type().name());
            }
            return super.attributeType();
        }

        @Override
        public String attributeName() {
            DynamoDbHashKey hashKey = this.actualOf(DynamoDbHashKey.class);
            if (hashKey != null && !hashKey.attributeName().isEmpty()) {
                return hashKey.attributeName();
            }
            DynamoDbIndexHashKey indexHashKey = this.actualOf(DynamoDbIndexHashKey.class);
            if (indexHashKey != null && !indexHashKey.attributeName().isEmpty()) {
                return indexHashKey.attributeName();
            }
            DynamoDbRangeKey rangeKey = this.actualOf(DynamoDbRangeKey.class);
            if (rangeKey != null && !rangeKey.attributeName().isEmpty()) {
                return rangeKey.attributeName();
            }
            DynamoDbIndexRangeKey indexRangeKey = this.actualOf(DynamoDbIndexRangeKey.class);
            if (indexRangeKey != null && !indexRangeKey.attributeName().isEmpty()) {
                return indexRangeKey.attributeName();
            }
            DynamoDbAttribute attribute = this.actualOf(DynamoDbAttribute.class);
            if (attribute != null && !attribute.attributeName().isEmpty()) {
                return attribute.attributeName();
            }
            DynamoDbVersionAttribute versionAttribute = this.actualOf(DynamoDbVersionAttribute.class);
            if (versionAttribute != null && !versionAttribute.attributeName().isEmpty()) {
                return versionAttribute.attributeName();
            }
            DynamoDbScalarAttribute scalarAttribute = this.actualOf(DynamoDbScalarAttribute.class);
            if (scalarAttribute != null && !scalarAttribute.attributeName().isEmpty()) {
                return scalarAttribute.attributeName();
            }
            DynamoDbNamed annotation = this.actualOf(DynamoDbNamed.class);
            if (annotation != null && !annotation.value().isEmpty()) {
                return annotation.value();
            }
            return this.defaultName;
        }

        @Override
        public KeyType keyType() {
            DynamoDbKeyed annotation = this.actualOf(DynamoDbKeyed.class);
            if (annotation != null) {
                return annotation.value();
            }
            return null;
        }

        @Override
        public boolean versioned() {
            return this.actualOf(DynamoDbVersioned.class) != null;
        }

        @Override
        public Map<KeyType, List<String>> globalSecondaryIndexNames() {
            DynamoDbIndexRangeKey indexRangeKey;
            EnumMap<KeyType, List<String>> gsis = new EnumMap<KeyType, List<String>>(KeyType.class);
            DynamoDbIndexHashKey indexHashKey = this.actualOf(DynamoDbIndexHashKey.class);
            if (indexHashKey != null) {
                if (!indexHashKey.globalSecondaryIndexName().isEmpty()) {
                    if (indexHashKey.globalSecondaryIndexNames().length > 0) {
                        throw new DynamoDbMappingException("@DynamoDBIndexHashKey must not specify both HASH GSI name/names");
                    }
                    gsis.put(KeyType.HASH, Collections.singletonList(indexHashKey.globalSecondaryIndexName()));
                } else if (indexHashKey.globalSecondaryIndexNames().length > 0) {
                    gsis.put(KeyType.HASH, Collections.unmodifiableList(Arrays.asList(indexHashKey.globalSecondaryIndexNames())));
                } else {
                    throw new DynamoDbMappingException("@DynamoDBIndexHashKey must specify one of HASH GSI name/names");
                }
            }
            if ((indexRangeKey = this.actualOf(DynamoDbIndexRangeKey.class)) != null) {
                if (!indexRangeKey.globalSecondaryIndexName().isEmpty()) {
                    if (indexRangeKey.globalSecondaryIndexNames().length > 0) {
                        throw new DynamoDbMappingException("@DynamoDBIndexRangeKey must not specify both RANGE GSI name/names");
                    }
                    gsis.put(KeyType.RANGE, Collections.singletonList(indexRangeKey.globalSecondaryIndexName()));
                } else if (indexRangeKey.globalSecondaryIndexNames().length > 0) {
                    gsis.put(KeyType.RANGE, Collections.unmodifiableList(Arrays.asList(indexRangeKey.globalSecondaryIndexNames())));
                } else if (this.localSecondaryIndexNames().isEmpty()) {
                    throw new DynamoDbMappingException("@DynamoDBIndexRangeKey must specify RANGE GSI and/or LSI name/names");
                }
            }
            if (!gsis.isEmpty()) {
                return Collections.unmodifiableMap(gsis);
            }
            return Collections.emptyMap();
        }

        @Override
        public List<String> localSecondaryIndexNames() {
            DynamoDbIndexRangeKey annotation = this.actualOf(DynamoDbIndexRangeKey.class);
            if (annotation != null) {
                if (!annotation.localSecondaryIndexName().isEmpty()) {
                    if (annotation.localSecondaryIndexNames().length > 0) {
                        throw new DynamoDbMappingException("@DynamoDBIndexRangeKey must not specify both LSI name/names");
                    }
                    return Collections.singletonList(annotation.localSecondaryIndexName());
                }
                if (annotation.localSecondaryIndexNames().length > 0) {
                    return Collections.unmodifiableList(Arrays.asList(annotation.localSecondaryIndexNames()));
                }
            }
            return Collections.emptyList();
        }
    }

    static final class TableMap<T>
    extends TypedMap<T>
    implements DynamoDbMapperTableModel.Properties<T> {
        private TableMap(Class<T> targetType) {
            super(targetType);
        }

        @Override
        public DynamoDbMapperFieldModel.DynamoDbAttributeType attributeType() {
            DynamoDbMapperFieldModel.DynamoDbAttributeType attributeType = super.attributeType();
            if (attributeType == null && this.actualOf(DynamoDbTable.class) != null) {
                attributeType = DynamoDbMapperFieldModel.DynamoDbAttributeType.M;
            }
            return attributeType;
        }

        @Override
        public String tableName() {
            DynamoDbTable annotation = this.actualOf(DynamoDbTable.class);
            if (annotation != null && !annotation.tableName().isEmpty()) {
                return annotation.tableName();
            }
            return null;
        }
    }

    static abstract class TypedMap<T>
    extends AbstractAnnotationMap {
        private final Class<T> targetType;

        private TypedMap(Class<T> targetType) {
            this.targetType = targetType;
        }

        final Class<T> targetType() {
            return this.targetType;
        }

        public DynamoDbMapperFieldModel.DynamoDbAttributeType attributeType() {
            DynamoDbTyped annotation = this.actualOf(DynamoDbTyped.class);
            if (annotation != null) {
                return annotation.value();
            }
            return null;
        }

        public <S> DynamoDbTypeConverter<S, T> typeConverter() {
            Annotation annotation = (Annotation)((AbstractAnnotationMap)this).map.get(DynamoDbTypeConverted.class);
            if (annotation != null) {
                DynamoDbTypeConverted converted = this.actualOf(DynamoDbTypeConverted.class);
                annotation = converted == annotation ? null : annotation;
                return (DynamoDbTypeConverter)StandardAnnotationMaps.overrideOf(converted.converter(), this.targetType, annotation);
            }
            return null;
        }

        public DynamoDbAutoGenerator<T> autoGenerator() {
            Annotation annotation = (Annotation)((AbstractAnnotationMap)this).map.get(DynamoDbAutoGenerated.class);
            if (annotation != null) {
                DynamoDbAutoGenerated generated = this.actualOf(DynamoDbAutoGenerated.class);
                annotation = generated == annotation ? null : annotation;
                DynamoDbAutoGenerator generator = (DynamoDbAutoGenerator)StandardAnnotationMaps.overrideOf(generated.generator(), this.targetType, annotation);
                if (generator.getGenerateStrategy() == DynamoDbAutoGenerateStrategy.CREATE && this.targetType.isPrimitive()) {
                    throw new DynamoDbMappingException("type [" + this.targetType + "] is not supported for auto-generation; primitives are not allowed when auto-generate strategy is CREATE");
                }
                return generator;
            }
            return null;
        }

        public Map<String, String> attributes() {
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            for (DynamoDbAttribute a : this.actualOf(DynamoDbFlattened.class).attributes()) {
                if (a.mappedBy().isEmpty() || a.attributeName().isEmpty()) {
                    throw new DynamoDbMappingException("@DynamoDBFlattened must specify mappedBy and attributeName");
                }
                if (attributes.put(a.mappedBy(), a.attributeName()) == null) continue;
                throw new DynamoDbMappingException("@DynamoDBFlattened must not duplicate mappedBy=" + a.mappedBy());
            }
            if (attributes.isEmpty()) {
                throw new DynamoDbMappingException("@DynamoDBFlattened must specify one or more attributes");
            }
            return attributes;
        }

        public boolean flattened() {
            return this.actualOf(DynamoDbFlattened.class) != null;
        }
    }

    private static abstract class AbstractAnnotationMap {
        private final Annotations map = new Annotations();

        private AbstractAnnotationMap() {
        }

        final <A extends Annotation> A actualOf(Class<A> annotationType) {
            Annotation annotation = (Annotation)this.map.get(annotationType);
            if (annotation == null || annotation.annotationType() == annotationType) {
                return (A)annotation;
            }
            if (annotation.annotationType().isAnnotationPresent(annotationType)) {
                return annotation.annotationType().getAnnotation(annotationType);
            }
            throw new DynamoDbMappingException("could not resolve annotation by type; @" + annotationType.getSimpleName() + " not present on " + annotation);
        }

        final void putAll(AnnotatedElement annotated) {
            if (annotated != null) {
                this.map.putAll(new Annotations().putAll(annotated.getAnnotations()));
            }
        }
    }
}

