/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.Select;

public class DynamoDbQueryExpression<T> {
    private boolean consistentRead = true;
    private boolean scanIndexForward = true;
    private T hashKeyValues;
    private Map<String, Condition> rangeKeyConditions;
    private Map<String, AttributeValue> exclusiveStartKey;
    private Integer limit;
    private String indexName;
    private Map<String, Condition> queryFilter;
    private String conditionalOperator;
    private String filterExpression;
    private String keyConditionExpression;
    private Map<String, String> expressionAttributeNames;
    private Map<String, AttributeValue> expressionAttributeValues;
    private String select;
    private String projectionExpression;
    private String returnConsumedCapacity;

    public boolean isConsistentRead() {
        return this.consistentRead;
    }

    public void setConsistentRead(boolean consistentRead) {
        this.consistentRead = consistentRead;
    }

    public DynamoDbQueryExpression<T> withConsistentRead(boolean consistentRead) {
        this.consistentRead = consistentRead;
        return this;
    }

    public boolean isScanIndexForward() {
        return this.scanIndexForward;
    }

    public void setScanIndexForward(boolean scanIndexForward) {
        this.scanIndexForward = scanIndexForward;
    }

    public DynamoDbQueryExpression<T> withScanIndexForward(boolean scanIndexForward) {
        this.scanIndexForward = scanIndexForward;
        return this;
    }

    public Map<String, AttributeValue> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public void setExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey;
    }

    public DynamoDbQueryExpression<T> withExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey;
        return this;
    }

    public Integer limit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public DynamoDbQueryExpression<T> withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public T getHashKeyValues() {
        return this.hashKeyValues;
    }

    public void setHashKeyValues(T hashKeyValues) {
        this.hashKeyValues = hashKeyValues;
    }

    public DynamoDbQueryExpression<T> withHashKeyValues(T hashKObject) {
        this.setHashKeyValues(hashKObject);
        return this;
    }

    public Map<String, Condition> getRangeKeyConditions() {
        return this.rangeKeyConditions;
    }

    public void setRangeKeyConditions(Map<String, Condition> rangeKeyConditions) {
        this.rangeKeyConditions = rangeKeyConditions;
    }

    public DynamoDbQueryExpression<T> withRangeKeyConditions(Map<String, Condition> rangeKeyConditions) {
        this.setRangeKeyConditions(rangeKeyConditions);
        return this;
    }

    public DynamoDbQueryExpression<T> withRangeKeyCondition(String rangeKeyAttributeName, Condition rangeKeyCondition) {
        if (this.rangeKeyConditions == null) {
            this.rangeKeyConditions = new HashMap<String, Condition>();
        }
        this.rangeKeyConditions.put(rangeKeyAttributeName, rangeKeyCondition);
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public DynamoDbQueryExpression<T> withIndexName(String indexName) {
        this.setIndexName(indexName);
        return this;
    }

    public Map<String, Condition> getQueryFilter() {
        return this.queryFilter;
    }

    public void setQueryFilter(Map<String, Condition> queryFilter) {
        this.queryFilter = queryFilter;
    }

    public DynamoDbQueryExpression<T> withQueryFilter(Map<String, Condition> queryFilter) {
        this.setQueryFilter(queryFilter);
        return this;
    }

    public DynamoDbQueryExpression<T> withQueryFilterEntry(String attributeName, Condition condition) {
        if (this.queryFilter == null) {
            this.queryFilter = new HashMap<String, Condition>();
        }
        this.queryFilter.put(attributeName, condition);
        return this;
    }

    public String getConditionalOperator() {
        return this.conditionalOperator;
    }

    public void setConditionalOperator(String conditionalOperator) {
        this.conditionalOperator = conditionalOperator;
    }

    public void setConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
    }

    public DynamoDbQueryExpression<T> withConditionalOperator(String conditionalOperator) {
        this.setConditionalOperator(conditionalOperator);
        return this;
    }

    public DynamoDbQueryExpression<T> withConditionalOperator(ConditionalOperator conditionalOperator) {
        this.setConditionalOperator(conditionalOperator);
        return this;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    public DynamoDbQueryExpression<T> withFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
        return this;
    }

    public String getKeyConditionExpression() {
        return this.keyConditionExpression;
    }

    public void setKeyConditionExpression(String keyConditionExpression) {
        this.keyConditionExpression = keyConditionExpression;
    }

    public DynamoDbQueryExpression<T> withKeyConditionExpression(String keyConditionExpression) {
        this.keyConditionExpression = keyConditionExpression;
        return this;
    }

    public Map<String, String> getExpressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.expressionAttributeNames = expressionAttributeNames;
    }

    public DynamoDbQueryExpression<T> withExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.setExpressionAttributeNames(expressionAttributeNames);
        return this;
    }

    public DynamoDbQueryExpression<T> addExpressionAttributeNamesEntry(String key, String value) {
        if (null == this.expressionAttributeNames) {
            this.expressionAttributeNames = new HashMap<String, String>();
        }
        if (this.expressionAttributeNames.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key + ") are provided.");
        }
        this.expressionAttributeNames.put(key, value);
        return this;
    }

    public DynamoDbQueryExpression<T> clearExpressionAttributeNamesEntries() {
        this.expressionAttributeNames = null;
        return this;
    }

    public Map<String, AttributeValue> getExpressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public void setExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
        this.expressionAttributeValues = expressionAttributeValues;
    }

    public DynamoDbQueryExpression<T> withExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
        this.setExpressionAttributeValues(expressionAttributeValues);
        return this;
    }

    public DynamoDbQueryExpression<T> addExpressionAttributeValuesEntry(String key, AttributeValue value) {
        if (null == this.expressionAttributeValues) {
            this.expressionAttributeValues = new HashMap<String, AttributeValue>();
        }
        if (this.expressionAttributeValues.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key + ") are provided.");
        }
        this.expressionAttributeValues.put(key, value);
        return this;
    }

    public DynamoDbQueryExpression<T> clearExpressionAttributeValuesEntries() {
        this.expressionAttributeValues = null;
        return this;
    }

    public String select() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public void setSelect(Select select) {
        this.select = select.toString();
    }

    public DynamoDbQueryExpression<T> withSelect(String select) {
        this.select = select;
        return this;
    }

    public DynamoDbQueryExpression<T> withSelect(Select select) {
        this.select = select.toString();
        return this;
    }

    public String getProjectionExpression() {
        return this.projectionExpression;
    }

    public void setProjectionExpression(String projectionExpression) {
        this.projectionExpression = projectionExpression;
    }

    public DynamoDbQueryExpression<T> withProjectionExpression(String projectionExpression) {
        this.projectionExpression = projectionExpression;
        return this;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public DynamoDbQueryExpression<T> withReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
        return this;
    }

    public DynamoDbQueryExpression<T> withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }
}

