/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbDeleteExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapper;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperConfig;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperTableModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbQueryExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbSaveExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbScanExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.IDynamoDbMapper;
import software.amazon.awssdk.services.dynamodb.datamodeling.KeyPair;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedParallelScanList;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedQueryList;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedScanList;
import software.amazon.awssdk.services.dynamodb.datamodeling.QueryResultPage;
import software.amazon.awssdk.services.dynamodb.datamodeling.S3ClientCache;
import software.amazon.awssdk.services.dynamodb.datamodeling.S3Link;
import software.amazon.awssdk.services.dynamodb.datamodeling.ScanResultPage;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;

public class AbstractDynamoDbMapper
implements IDynamoDbMapper {
    private final DynamoDbMapperConfig config;

    protected AbstractDynamoDbMapper(DynamoDbMapperConfig defaults) {
        this.config = DynamoDbMapperConfig.DEFAULT.merge(defaults);
    }

    protected AbstractDynamoDbMapper() {
        this(DynamoDbMapperConfig.DEFAULT);
    }

    protected final String getTableName(Class<?> clazz, Object object, DynamoDbMapperConfig config) {
        if (object != null && config.getObjectTableNameResolver() != null) {
            return config.getObjectTableNameResolver().getTableName(object, config);
        }
        return this.getTableName(clazz, config);
    }

    protected final String getTableName(Class<?> clazz, DynamoDbMapperConfig config) {
        if (config.getTableNameResolver() == null) {
            return DynamoDbMapperConfig.DefaultTableNameResolver.INSTANCE.getTableName(clazz, config);
        }
        return config.getTableNameResolver().getTableName(clazz, config);
    }

    protected final DynamoDbMapperConfig mergeConfig(DynamoDbMapperConfig overrides) {
        return this.config.merge(overrides);
    }

    @Override
    public <T> DynamoDbMapperTableModel<T> getTableModel(Class<T> clazz) {
        return this.getTableModel(clazz, this.config);
    }

    @Override
    public <T> DynamoDbMapperTableModel<T> getTableModel(Class<T> clazz, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> T load(Class<T> clazz, Object hashKey, DynamoDbMapperConfig config) {
        return this.load(clazz, hashKey, null, config);
    }

    @Override
    public <T> T load(Class<T> clazz, Object hashKey) {
        return this.load(clazz, hashKey, null, this.config);
    }

    @Override
    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey) {
        return this.load(clazz, hashKey, rangeKey, this.config);
    }

    @Override
    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> T load(T keyObject) {
        return this.load(keyObject, this.config);
    }

    @Override
    public <T> T load(T keyObject, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> T marshallIntoObject(Class<T> clazz, Map<String, AttributeValue> itemAttributes) {
        return this.marshallIntoObject(clazz, itemAttributes, this.config);
    }

    public <T> T marshallIntoObject(Class<T> clazz, Map<String, AttributeValue> itemAttributes, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> List<T> marshallIntoObjects(Class<T> clazz, List<Map<String, AttributeValue>> itemAttributes) {
        return this.marshallIntoObjects(clazz, itemAttributes, this.config);
    }

    public <T> List<T> marshallIntoObjects(Class<T> clazz, List<Map<String, AttributeValue>> itemAttributes, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> void save(T object) {
        this.save(object, null, this.config);
    }

    @Override
    public <T> void save(T object, DynamoDbSaveExpression saveExpression) {
        this.save(object, saveExpression, this.config);
    }

    @Override
    public <T> void save(T object, DynamoDbMapperConfig config) {
        this.save(object, null, config);
    }

    @Override
    public <T> void save(T object, DynamoDbSaveExpression saveExpression, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public void delete(Object object) {
        this.delete(object, null, this.config);
    }

    @Override
    public void delete(Object object, DynamoDbDeleteExpression deleteExpression) {
        this.delete(object, deleteExpression, this.config);
    }

    @Override
    public void delete(Object object, DynamoDbMapperConfig config) {
        this.delete(object, null, config);
    }

    @Override
    public <T> void delete(T object, DynamoDbDeleteExpression deleteExpression, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public List<DynamoDbMapper.FailedBatch> batchDelete(Iterable<? extends Object> objectsToDelete) {
        return this.batchWrite(Collections.emptyList(), objectsToDelete, this.config);
    }

    @Override
    public List<DynamoDbMapper.FailedBatch> batchDelete(Object ... objectsToDelete) {
        return this.batchWrite(Collections.emptyList(), Arrays.asList(objectsToDelete), this.config);
    }

    @Override
    public List<DynamoDbMapper.FailedBatch> batchSave(Iterable<? extends Object> objectsToSave) {
        return this.batchWrite(objectsToSave, Collections.emptyList(), this.config);
    }

    @Override
    public List<DynamoDbMapper.FailedBatch> batchSave(Object ... objectsToSave) {
        return this.batchWrite(Arrays.asList(objectsToSave), Collections.emptyList(), this.config);
    }

    @Override
    public List<DynamoDbMapper.FailedBatch> batchWrite(Iterable<? extends Object> objectsToWrite, Iterable<? extends Object> objectsToDelete) {
        return this.batchWrite(objectsToWrite, objectsToDelete, this.config);
    }

    @Override
    public List<DynamoDbMapper.FailedBatch> batchWrite(Iterable<? extends Object> objectsToWrite, Iterable<? extends Object> objectsToDelete, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public Map<String, List<Object>> batchLoad(Iterable<? extends Object> itemsToGet) {
        return this.batchLoad(itemsToGet, this.config);
    }

    @Override
    public Map<String, List<Object>> batchLoad(Iterable<? extends Object> itemsToGet, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet) {
        return this.batchLoad(itemsToGet, this.config);
    }

    @Override
    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> PaginatedScanList<T> scan(Class<T> clazz, DynamoDbScanExpression scanExpression) {
        return this.scan(clazz, scanExpression, this.config);
    }

    @Override
    public <T> PaginatedScanList<T> scan(Class<T> clazz, DynamoDbScanExpression scanExpression, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> PaginatedParallelScanList<T> parallelScan(Class<T> clazz, DynamoDbScanExpression scanExpression, int totalSegments) {
        return this.parallelScan(clazz, scanExpression, totalSegments, this.config);
    }

    @Override
    public <T> PaginatedParallelScanList<T> parallelScan(Class<T> clazz, DynamoDbScanExpression scanExpression, int totalSegments, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> ScanResultPage<T> scanPage(Class<T> clazz, DynamoDbScanExpression scanExpression) {
        return this.scanPage(clazz, scanExpression, this.config);
    }

    @Override
    public <T> ScanResultPage<T> scanPage(Class<T> clazz, DynamoDbScanExpression scanExpression, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public int count(Class<?> clazz, DynamoDbScanExpression scanExpression) {
        return this.count(clazz, scanExpression, this.config);
    }

    @Override
    public int count(Class<?> clazz, DynamoDbScanExpression scanExpression, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> int count(Class<T> clazz, DynamoDbQueryExpression<T> queryExpression) {
        return this.count(clazz, queryExpression, this.config);
    }

    @Override
    public <T> int count(Class<T> clazz, DynamoDbQueryExpression<T> queryExpression, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> PaginatedQueryList<T> query(Class<T> clazz, DynamoDbQueryExpression<T> queryExpression) {
        return this.query(clazz, queryExpression, this.config);
    }

    @Override
    public <T> PaginatedQueryList<T> query(Class<T> clazz, DynamoDbQueryExpression<T> queryExpression, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> QueryResultPage<T> queryPage(Class<T> clazz, DynamoDbQueryExpression<T> queryExpression) {
        return this.queryPage(clazz, queryExpression, this.config);
    }

    @Override
    public <T> QueryResultPage<T> queryPage(Class<T> clazz, DynamoDbQueryExpression<T> queryExpression, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public S3ClientCache s3ClientCache() {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public S3Link createS3Link(String bucketName, String key) {
        return this.createS3Link((Region)null, bucketName, key);
    }

    @Override
    public S3Link createS3Link(Region s3region, String bucketName, String key) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public S3Link createS3Link(String s3region, String bucketName, String key) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public CreateTableRequest generateCreateTableRequest(Class<?> clazz) {
        return this.generateCreateTableRequest(clazz, this.config);
    }

    public <T> CreateTableRequest generateCreateTableRequest(Class<T> clazz, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public DeleteTableRequest generateDeleteTableRequest(Class<?> clazz) {
        return this.generateDeleteTableRequest(clazz, this.config);
    }

    public <T> DeleteTableRequest generateDeleteTableRequest(Class<T> clazz, DynamoDbMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }
}

