/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient;

import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;

@SdkProtectedApi
public class OperationContext {
    private final String tableName;
    private final String indexName;

    private OperationContext(String tableName, String indexName) {
        this.tableName = tableName;
        this.indexName = indexName;
    }

    public static OperationContext of(String tableName, String indexName) {
        return new OperationContext(tableName, indexName);
    }

    public static OperationContext of(String tableName) {
        return new OperationContext(tableName, TableMetadata.getPrimaryIndexName());
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationContext that = (OperationContext)o;
        if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) {
            return false;
        }
        return this.indexName != null ? this.indexName.equals(that.indexName) : that.indexName == null;
    }

    public int hashCode() {
        int result = this.tableName != null ? this.tableName.hashCode() : 0;
        result = 31 * result + (this.indexName != null ? this.indexName.hashCode() : 0);
        return result;
    }
}

