/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient;

import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkPublicApi
public interface TableOperation<ItemT, RequestT, ResponseT, ResultT> {
    public RequestT generateRequest(TableSchema<ItemT> var1, OperationContext var2, MapperExtension var3);

    public Function<RequestT, ResponseT> getServiceCall(DynamoDbClient var1);

    public ResultT transformResponse(ResponseT var1, TableSchema<ItemT> var2, OperationContext var3, MapperExtension var4);

    default public ResultT execute(TableSchema<ItemT> tableSchema, OperationContext context, MapperExtension mapperExtension, DynamoDbClient dynamoDbClient) {
        RequestT request = this.generateRequest(tableSchema, context, mapperExtension);
        ResponseT response = this.getServiceCall(dynamoDbClient).apply(request);
        return this.transformResponse(response, tableSchema, context, mapperExtension);
    }
}

