/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.KeyAttributeMetadata;
import software.amazon.awssdk.enhanced.dynamodb.mapper.Order;

@SdkInternalApi
public class StaticKeyAttributeMetadata
implements KeyAttributeMetadata {
    private final String name;
    private final AttributeValueType attributeValueType;
    private final Order order;

    private StaticKeyAttributeMetadata(String name, AttributeValueType attributeValueType, Order order) {
        this.name = name;
        this.attributeValueType = attributeValueType;
        this.order = order;
    }

    public static StaticKeyAttributeMetadata create(String name, AttributeValueType attributeValueType) {
        return new StaticKeyAttributeMetadata(name, attributeValueType, Order.UNSPECIFIED);
    }

    public static StaticKeyAttributeMetadata create(String name, AttributeValueType attributeValueType, Order order) {
        return new StaticKeyAttributeMetadata(name, attributeValueType, order);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public AttributeValueType attributeValueType() {
        return this.attributeValueType;
    }

    @Override
    public Order order() {
        return this.order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticKeyAttributeMetadata staticKey = (StaticKeyAttributeMetadata)o;
        if (this.name != null ? !this.name.equals(staticKey.name) : staticKey.name != null) {
            return false;
        }
        if (this.attributeValueType != staticKey.attributeValueType) {
            return false;
        }
        return this.order == staticKey.order;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.attributeValueType != null ? this.attributeValueType.hashCode() : 0);
        result = 31 * result + this.order.hashCode();
        return result;
    }
}

