/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.LambdaToMethodBridgeBuilder;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.internal.ReflectionUtils;

@FunctionalInterface
@SdkInternalApi
public interface BeanAttributeSetter<BeanT, GetterT>
extends BiConsumer<BeanT, GetterT> {
    public static <BeanT, SetterT> BeanAttributeSetter<BeanT, SetterT> create(Class<BeanT> beanClass, Method setter, MethodHandles.Lookup lookup) {
        Validate.isTrue((setter.getParameterCount() == 1 ? 1 : 0) != 0, (String)"%s.%s doesn't have just 1 parameter, despite being named like a setter.", (Object[])new Object[]{beanClass, setter.getName()});
        Class<?> setterInputClass = setter.getParameters()[0].getType();
        Class boxedInputClass = ReflectionUtils.getWrappedClass(setterInputClass);
        return LambdaToMethodBridgeBuilder.create(BeanAttributeSetter.class).lookup(lookup).lambdaMethodName("accept").runtimeLambdaSignature(Void.TYPE, Object.class, Object.class).compileTimeLambdaSignature(Void.TYPE, beanClass, boxedInputClass).targetMethod(setter).build();
    }
}

