/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.BatchableWriteOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.OperationName;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TableOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TransactableWriteOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.DeleteItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.DeleteItemEnhancedResponse;
import software.amazon.awssdk.enhanced.dynamodb.model.TransactDeleteItemEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Delete;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.utils.Either;

@SdkInternalApi
public class DeleteItemOperation<T>
implements TableOperation<T, DeleteItemRequest, DeleteItemResponse, DeleteItemEnhancedResponse<T>>,
TransactableWriteOperation<T>,
BatchableWriteOperation<T> {
    private final Either<DeleteItemEnhancedRequest, TransactDeleteItemEnhancedRequest> request;

    private DeleteItemOperation(DeleteItemEnhancedRequest request) {
        this.request = Either.left((Object)request);
    }

    private DeleteItemOperation(TransactDeleteItemEnhancedRequest request) {
        this.request = Either.right((Object)request);
    }

    public static <T> DeleteItemOperation<T> create(DeleteItemEnhancedRequest request) {
        return new DeleteItemOperation<T>(request);
    }

    public static <T> DeleteItemOperation<T> create(TransactDeleteItemEnhancedRequest request) {
        return new DeleteItemOperation<T>(request);
    }

    @Override
    public OperationName operationName() {
        return OperationName.DELETE_ITEM;
    }

    @Override
    public DeleteItemRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        if (!TableMetadata.primaryIndexName().equals(operationContext.indexName())) {
            throw new IllegalArgumentException("DeleteItem cannot be executed against a secondary index.");
        }
        Key key = (Key)this.request.map(DeleteItemEnhancedRequest::key, TransactDeleteItemEnhancedRequest::key);
        DeleteItemRequest.Builder requestBuilder = DeleteItemRequest.builder().tableName(operationContext.tableName()).key(key.keyMap(tableSchema, operationContext.indexName())).returnValues(ReturnValue.ALL_OLD);
        if (this.request.left().isPresent()) {
            requestBuilder = this.addPlainDeleteItemParameters(requestBuilder, (DeleteItemEnhancedRequest)this.request.left().get());
        }
        requestBuilder = this.addExpressionsIfExist(requestBuilder);
        return (DeleteItemRequest)requestBuilder.build();
    }

    @Override
    public DeleteItemEnhancedResponse<T> transformResponse(DeleteItemResponse response, TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        T attributes = EnhancedClientUtils.readAndTransformSingleItem(response.attributes(), tableSchema, operationContext, extension);
        return DeleteItemEnhancedResponse.builder(null).attributes(attributes).consumedCapacity(response.consumedCapacity()).itemCollectionMetrics(response.itemCollectionMetrics()).build();
    }

    @Override
    public Function<DeleteItemRequest, DeleteItemResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).deleteItem(arg_0);
    }

    @Override
    public Function<DeleteItemRequest, CompletableFuture<DeleteItemResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).deleteItem(arg_0);
    }

    @Override
    public WriteRequest generateWriteRequest(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        DeleteItemRequest deleteItemRequest = this.generateRequest(tableSchema, operationContext, extension);
        return (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key(deleteItemRequest.key()).build()).build();
    }

    @Override
    public TransactWriteItem generateTransactWriteItem(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension dynamoDbEnhancedClientExtension) {
        DeleteItemRequest deleteItemRequest = this.generateRequest(tableSchema, operationContext, dynamoDbEnhancedClientExtension);
        Delete.Builder builder = Delete.builder().key(deleteItemRequest.key()).tableName(deleteItemRequest.tableName()).conditionExpression(deleteItemRequest.conditionExpression()).expressionAttributeValues(deleteItemRequest.expressionAttributeValues()).expressionAttributeNames(deleteItemRequest.expressionAttributeNames());
        this.request.right().map(TransactDeleteItemEnhancedRequest::returnValuesOnConditionCheckFailureAsString).ifPresent(arg_0 -> ((Delete.Builder)builder).returnValuesOnConditionCheckFailure(arg_0));
        return (TransactWriteItem)TransactWriteItem.builder().delete((Delete)builder.build()).build();
    }

    private DeleteItemRequest.Builder addExpressionsIfExist(DeleteItemRequest.Builder requestBuilder) {
        Expression conditionExpression = ((Optional)this.request.map(r -> Optional.ofNullable(r.conditionExpression()), r -> Optional.ofNullable(r.conditionExpression()))).orElse(null);
        if (conditionExpression != null) {
            requestBuilder = requestBuilder.conditionExpression(conditionExpression.expression());
            Map<String, String> expressionNames = conditionExpression.expressionNames();
            Map<String, AttributeValue> expressionValues = conditionExpression.expressionValues();
            if (expressionNames != null && !expressionNames.isEmpty()) {
                requestBuilder = requestBuilder.expressionAttributeNames(expressionNames);
            }
            if (expressionValues != null && !expressionValues.isEmpty()) {
                requestBuilder = requestBuilder.expressionAttributeValues(expressionValues);
            }
        }
        return requestBuilder;
    }

    private DeleteItemRequest.Builder addPlainDeleteItemParameters(DeleteItemRequest.Builder requestBuilder, DeleteItemEnhancedRequest enhancedRequest) {
        requestBuilder = requestBuilder.returnConsumedCapacity(enhancedRequest.returnConsumedCapacityAsString());
        requestBuilder = requestBuilder.returnItemCollectionMetrics(enhancedRequest.returnItemCollectionMetricsAsString());
        requestBuilder = requestBuilder.returnValuesOnConditionCheckFailure(enhancedRequest.returnValuesOnConditionCheckFailureAsString());
        return requestBuilder;
    }
}

