/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.LocalDate;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.InstantAsStringAttributeConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class LocalDateAttributeConverter
implements AttributeConverter<LocalDate> {
    private static final Visitor VISITOR = new Visitor();

    private LocalDateAttributeConverter() {
    }

    public static LocalDateAttributeConverter create() {
        return new LocalDateAttributeConverter();
    }

    @Override
    public EnhancedType<LocalDate> type() {
        return EnhancedType.of(LocalDate.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(LocalDate input) {
        return (AttributeValue)AttributeValue.builder().s(input.toString()).build();
    }

    @Override
    public LocalDate transformTo(AttributeValue input) {
        try {
            if (input.s() != null) {
                return EnhancedAttributeValue.fromString(input.s()).convert(VISITOR);
            }
            return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static final class Visitor
    extends TypeConvertingVisitor<LocalDate> {
        private Visitor() {
            super(LocalDate.class, InstantAsStringAttributeConverter.class);
        }

        @Override
        public LocalDate convertString(String value) {
            return LocalDate.parse(value);
        }
    }
}

