/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.immutable;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.internal.immutable.ImmutableInfo;
import software.amazon.awssdk.enhanced.dynamodb.internal.immutable.ImmutablePropertyDescriptor;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbIgnore;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbImmutable;

@SdkInternalApi
public class ImmutableIntrospector {
    private static final String BUILD_METHOD = "build";
    private static final String BUILDER_METHOD = "builder";
    private static final String TO_BUILDER_METHOD = "toBuilder";
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private static final String SET_PREFIX = "set";
    private static final String[] METHODS_TO_IGNORE = new String[]{"toBuilder"};
    private static volatile ImmutableIntrospector INSTANCE = null;
    private final Set<String> namesToExclude = Collections.unmodifiableSet(Stream.concat(Arrays.stream(Object.class.getMethods()).map(Method::getName), Arrays.stream(METHODS_TO_IGNORE)).collect(Collectors.toSet()));

    private ImmutableIntrospector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> ImmutableInfo<T> getImmutableInfo(Class<T> immutableClass) {
        if (INSTANCE != null) return INSTANCE.introspect(immutableClass);
        Class<ImmutableIntrospector> clazz = ImmutableIntrospector.class;
        synchronized (ImmutableIntrospector.class) {
            if (INSTANCE != null) return INSTANCE.introspect(immutableClass);
            INSTANCE = new ImmutableIntrospector();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE.introspect(immutableClass);
        }
    }

    private <T> ImmutableInfo<T> introspect(Class<T> immutableClass) {
        Class<?> builderClass = this.validateAndGetBuilderClass(immutableClass);
        Optional<Method> staticBuilderMethod = this.findStaticBuilderMethod(immutableClass, builderClass);
        List<Method> getters = this.filterAndCollectGetterMethods(immutableClass.getMethods());
        Map<String, Method> indexedBuilderMethods = this.filterAndIndexBuilderMethods(builderClass.getMethods());
        Method buildMethod = this.extractBuildMethod(indexedBuilderMethods, immutableClass).orElseThrow(() -> new IllegalArgumentException("An immutable builder class must have a public method named 'build()' that takes no arguments and returns an instance of the immutable class it builds"));
        List<ImmutablePropertyDescriptor> propertyDescriptors = getters.stream().map(getter -> {
            this.validateGetter((Method)getter);
            String propertyName = this.normalizeGetterName((Method)getter);
            Method setter = this.extractSetterMethod(propertyName, indexedBuilderMethods, (Method)getter, builderClass).orElseThrow(() -> this.generateExceptionForMethod((Method)getter, "A method was found on the immutable class that does not appear to have a matching setter on the builder class."));
            return ImmutablePropertyDescriptor.create(propertyName, getter, setter);
        }).collect(Collectors.toList());
        if (!indexedBuilderMethods.isEmpty()) {
            throw this.generateExceptionForMethod(indexedBuilderMethods.values().iterator().next(), "A method was found on the immutable class builder that does not appear to have a matching getter on the immutable class.");
        }
        return ImmutableInfo.builder(immutableClass).builderClass(builderClass).staticBuilderMethod(staticBuilderMethod.orElse(null)).buildMethod(buildMethod).propertyDescriptors(propertyDescriptors).build();
    }

    private boolean isMappableMethod(Method method) {
        return method.getDeclaringClass() != Object.class && method.getAnnotation(DynamoDbIgnore.class) == null && !method.isSynthetic() && !method.isBridge() && !Modifier.isStatic(method.getModifiers()) && !this.namesToExclude.contains(method.getName());
    }

    private Optional<Method> findStaticBuilderMethod(Class<?> immutableClass, Class<?> builderClass) {
        try {
            Method method = immutableClass.getMethod(BUILDER_METHOD, new Class[0]);
            if (Modifier.isStatic(method.getModifiers()) && method.getReturnType().isAssignableFrom(builderClass)) {
                return Optional.of(method);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private IllegalArgumentException generateExceptionForMethod(Method getter, String message) {
        return new IllegalArgumentException(message + " Use the @DynamoDbIgnore annotation on the method if you do not want it to be included in the TableSchema introspection. [Method = \"" + getter + "\"]");
    }

    private Class<?> validateAndGetBuilderClass(Class<?> immutableClass) {
        DynamoDbImmutable dynamoDbImmutable = immutableClass.getAnnotation(DynamoDbImmutable.class);
        if (dynamoDbImmutable == null) {
            throw new IllegalArgumentException("A DynamoDb immutable class must be annotated with @DynamoDbImmutable");
        }
        return dynamoDbImmutable.builder();
    }

    private void validateGetter(Method getter) {
        if (getter.getReturnType() == Void.TYPE || getter.getReturnType() == Void.class) {
            throw this.generateExceptionForMethod(getter, "A method was found on the immutable class that does not appear to be a valid getter due to the return type being void.");
        }
        if (getter.getParameterCount() != 0) {
            throw this.generateExceptionForMethod(getter, "A method was found on the immutable class that does not appear to be a valid getter due to it having one or more parameters.");
        }
    }

    private List<Method> filterAndCollectGetterMethods(Method[] rawMethods) {
        return Arrays.stream(rawMethods).filter(this::isMappableMethod).collect(Collectors.toList());
    }

    private Map<String, Method> filterAndIndexBuilderMethods(Method[] rawMethods) {
        return Arrays.stream(rawMethods).filter(this::isMappableMethod).collect(Collectors.toMap(this::normalizeSetterName, m -> m));
    }

    private String normalizeSetterName(Method setter) {
        String setterName = setter.getName();
        if (setterName.length() > 3 && Character.isUpperCase(setterName.charAt(3)) && setterName.startsWith(SET_PREFIX)) {
            return Character.toLowerCase(setterName.charAt(3)) + setterName.substring(4);
        }
        return setterName;
    }

    private String normalizeGetterName(Method getter) {
        String getterName = getter.getName();
        if (getterName.length() > 2 && Character.isUpperCase(getterName.charAt(2)) && getterName.startsWith(IS_PREFIX) && this.isMethodBoolean(getter)) {
            return Character.toLowerCase(getterName.charAt(2)) + getterName.substring(3);
        }
        if (getterName.length() > 3 && Character.isUpperCase(getterName.charAt(3)) && getterName.startsWith(GET_PREFIX)) {
            return Character.toLowerCase(getterName.charAt(3)) + getterName.substring(4);
        }
        return getterName;
    }

    private boolean isMethodBoolean(Method method) {
        return method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class;
    }

    private Optional<Method> extractBuildMethod(Map<String, Method> indexedBuilderMethods, Class<?> immutableClass) {
        Method buildMethod = indexedBuilderMethods.get(BUILD_METHOD);
        if (buildMethod == null || buildMethod.getParameterCount() != 0 || !immutableClass.equals(buildMethod.getReturnType())) {
            return Optional.empty();
        }
        indexedBuilderMethods.remove(BUILD_METHOD);
        return Optional.of(buildMethod);
    }

    private Optional<Method> extractSetterMethod(String propertyName, Map<String, Method> indexedBuilderMethods, Method getterMethod, Class<?> builderClass) {
        Method setterMethod = indexedBuilderMethods.get(propertyName);
        if (setterMethod == null || !this.setterHasValidSignature(setterMethod, getterMethod.getReturnType(), builderClass)) {
            return Optional.empty();
        }
        indexedBuilderMethods.remove(propertyName);
        return Optional.of(setterMethod);
    }

    private boolean setterHasValidSignature(Method setterMethod, Class<?> expectedType, Class<?> builderClass) {
        return this.setterHasValidParameterSignature(setterMethod, expectedType) && this.setterHasValidReturnType(setterMethod, builderClass);
    }

    private boolean setterHasValidParameterSignature(Method setterMethod, Class<?> expectedType) {
        return setterMethod.getParameterCount() == 1 && expectedType.equals(setterMethod.getParameterTypes()[0]);
    }

    private boolean setterHasValidReturnType(Method setterMethod, Class<?> builderClass) {
        if (setterMethod.getReturnType() == Void.TYPE || setterMethod.getReturnType() == Void.class) {
            return true;
        }
        return setterMethod.getReturnType().isAssignableFrom(builderClass);
    }
}

