/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.client;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.client.DefaultDynamoDbIndex;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.CreateTableOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DeleteItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.GetItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.PutItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.QueryOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.ScanOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.UpdateItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.CreateTableEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.DeleteItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.GetItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.PageIterable;
import software.amazon.awssdk.enhanced.dynamodb.model.PutItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.ScanEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.UpdateItemEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkInternalApi
public class DefaultDynamoDbTable<T>
implements DynamoDbTable<T> {
    private final DynamoDbClient dynamoDbClient;
    private final DynamoDbEnhancedClientExtension extension;
    private final TableSchema<T> tableSchema;
    private final String tableName;

    DefaultDynamoDbTable(DynamoDbClient dynamoDbClient, DynamoDbEnhancedClientExtension extension, TableSchema<T> tableSchema, String tableName) {
        this.dynamoDbClient = dynamoDbClient;
        this.extension = extension;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
    }

    @Override
    public DynamoDbEnhancedClientExtension mapperExtension() {
        return this.extension;
    }

    @Override
    public TableSchema<T> tableSchema() {
        return this.tableSchema;
    }

    public DynamoDbClient dynamoDbClient() {
        return this.dynamoDbClient;
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    @Override
    public DefaultDynamoDbIndex<T> index(String indexName) {
        this.tableSchema.tableMetadata().indexPartitionKey(indexName);
        return new DefaultDynamoDbIndex<T>(this.dynamoDbClient, this.extension, this.tableSchema, this.tableName, indexName);
    }

    @Override
    public void createTable(CreateTableEnhancedRequest request) {
        CreateTableOperation operation = CreateTableOperation.create(request);
        operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public void createTable(Consumer<CreateTableEnhancedRequest.Builder> requestConsumer) {
        CreateTableEnhancedRequest.Builder builder = CreateTableEnhancedRequest.builder();
        requestConsumer.accept(builder);
        this.createTable(builder.build());
    }

    @Override
    public void createTable() {
        this.createTable(CreateTableEnhancedRequest.builder().build());
    }

    @Override
    public T deleteItem(DeleteItemEnhancedRequest request) {
        DeleteItemOperation operation = DeleteItemOperation.create(request);
        return (T)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public T deleteItem(Consumer<DeleteItemEnhancedRequest.Builder> requestConsumer) {
        DeleteItemEnhancedRequest.Builder builder = DeleteItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return (T)this.deleteItem((T)builder.build());
    }

    @Override
    public T deleteItem(Key key) {
        return (T)this.deleteItem((T)((Consumer<DeleteItemEnhancedRequest.Builder>)r -> r.key(key)));
    }

    @Override
    public T deleteItem(T keyItem) {
        return (T)this.deleteItem((T)this.keyFrom(keyItem));
    }

    @Override
    public T getItem(GetItemEnhancedRequest request) {
        GetItemOperation operation = GetItemOperation.create(request);
        return (T)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public T getItem(Consumer<GetItemEnhancedRequest.Builder> requestConsumer) {
        GetItemEnhancedRequest.Builder builder = GetItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return (T)this.getItem((T)builder.build());
    }

    @Override
    public T getItem(Key key) {
        return (T)this.getItem((T)((Consumer<GetItemEnhancedRequest.Builder>)r -> r.key(key)));
    }

    @Override
    public T getItem(T keyItem) {
        return (T)this.getItem((T)this.keyFrom(keyItem));
    }

    @Override
    public PageIterable<T> query(QueryEnhancedRequest request) {
        QueryOperation operation = QueryOperation.create(request);
        return operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public PageIterable<T> query(Consumer<QueryEnhancedRequest.Builder> requestConsumer) {
        QueryEnhancedRequest.Builder builder = QueryEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.query(builder.build());
    }

    @Override
    public PageIterable<T> query(QueryConditional queryConditional) {
        return this.query((QueryEnhancedRequest.Builder r) -> r.queryConditional(queryConditional));
    }

    @Override
    public void putItem(PutItemEnhancedRequest<T> request) {
        PutItemOperation<T> operation = PutItemOperation.create(request);
        operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public void putItem(Consumer<PutItemEnhancedRequest.Builder<T>> requestConsumer) {
        PutItemEnhancedRequest.Builder<T> builder = PutItemEnhancedRequest.builder(this.tableSchema.itemType().rawClass());
        requestConsumer.accept(builder);
        this.putItem((T)builder.build());
    }

    @Override
    public void putItem(T item) {
        this.putItem((T)((Consumer<PutItemEnhancedRequest.Builder>)r -> r.item(item)));
    }

    @Override
    public PageIterable<T> scan(ScanEnhancedRequest request) {
        ScanOperation operation = ScanOperation.create(request);
        return operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public PageIterable<T> scan(Consumer<ScanEnhancedRequest.Builder> requestConsumer) {
        ScanEnhancedRequest.Builder builder = ScanEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.scan(builder.build());
    }

    @Override
    public PageIterable<T> scan() {
        return this.scan(ScanEnhancedRequest.builder().build());
    }

    @Override
    public T updateItem(UpdateItemEnhancedRequest<T> request) {
        UpdateItemOperation<T> operation = UpdateItemOperation.create(request);
        return (T)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public T updateItem(Consumer<UpdateItemEnhancedRequest.Builder<T>> requestConsumer) {
        UpdateItemEnhancedRequest.Builder<T> builder = UpdateItemEnhancedRequest.builder(this.tableSchema.itemType().rawClass());
        requestConsumer.accept(builder);
        return (T)this.updateItem((T)builder.build());
    }

    @Override
    public T updateItem(T item) {
        return (T)this.updateItem((T)((Consumer<UpdateItemEnhancedRequest.Builder>)r -> r.item(item)));
    }

    @Override
    public Key keyFrom(T item) {
        return EnhancedClientUtils.createKeyFromItem(item, this.tableSchema, TableMetadata.primaryIndexName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDynamoDbTable that = (DefaultDynamoDbTable)o;
        if (this.dynamoDbClient != null ? !this.dynamoDbClient.equals(that.dynamoDbClient) : that.dynamoDbClient != null) {
            return false;
        }
        if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) {
            return false;
        }
        if (this.tableSchema != null ? !this.tableSchema.equals(that.tableSchema) : that.tableSchema != null) {
            return false;
        }
        return this.tableName != null ? this.tableName.equals(that.tableName) : that.tableName == null;
    }

    public int hashCode() {
        int result = this.dynamoDbClient != null ? this.dynamoDbClient.hashCode() : 0;
        result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
        result = 31 * result + (this.tableSchema != null ? this.tableSchema.hashCode() : 0);
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        return result;
    }
}

