/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DatabaseOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.TransactWriteItemsEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;

@SdkInternalApi
public class TransactWriteItemsOperation
implements DatabaseOperation<TransactWriteItemsRequest, TransactWriteItemsResponse, Void> {
    private TransactWriteItemsEnhancedRequest request;

    private TransactWriteItemsOperation(TransactWriteItemsEnhancedRequest request) {
        this.request = request;
    }

    public static TransactWriteItemsOperation create(TransactWriteItemsEnhancedRequest request) {
        return new TransactWriteItemsOperation(request);
    }

    @Override
    public TransactWriteItemsRequest generateRequest(DynamoDbEnhancedClientExtension extension) {
        return (TransactWriteItemsRequest)TransactWriteItemsRequest.builder().transactItems(this.request.transactWriteItems()).build();
    }

    @Override
    public Void transformResponse(TransactWriteItemsResponse response, DynamoDbEnhancedClientExtension extension) {
        return null;
    }

    @Override
    public Function<TransactWriteItemsRequest, TransactWriteItemsResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).transactWriteItems(arg_0);
    }

    @Override
    public Function<TransactWriteItemsRequest, CompletableFuture<TransactWriteItemsResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).transactWriteItems(arg_0);
    }
}

