/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.LocalDate;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.LocalDateTimeAttributeConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class LocalDateAttributeConverter
implements AttributeConverter<LocalDate> {
    private static final LocalDateTimeAttributeConverter LOCAL_DATE_TIME_ATTRIBUTE_CONVERTER = LocalDateTimeAttributeConverter.create();

    private LocalDateAttributeConverter() {
    }

    public static LocalDateAttributeConverter create() {
        return new LocalDateAttributeConverter();
    }

    @Override
    public EnhancedType<LocalDate> type() {
        return EnhancedType.of(LocalDate.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(LocalDate input) {
        return LOCAL_DATE_TIME_ATTRIBUTE_CONVERTER.transformFrom(input.atStartOfDay());
    }

    @Override
    public LocalDate transformTo(AttributeValue input) {
        return LOCAL_DATE_TIME_ATTRIBUTE_CONVERTER.transformTo(input).toLocalDate();
    }
}

