/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.AtomicBooleanStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class AtomicBooleanAttributeConverter
implements AttributeConverter<AtomicBoolean> {
    private static final Visitor VISITOR = new Visitor();
    private static final AtomicBooleanStringConverter STRING_CONVERTER = AtomicBooleanStringConverter.create();

    private AtomicBooleanAttributeConverter() {
    }

    @Override
    public EnhancedType<AtomicBoolean> type() {
        return EnhancedType.of(AtomicBoolean.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.BOOL;
    }

    public static AtomicBooleanAttributeConverter create() {
        return new AtomicBooleanAttributeConverter();
    }

    @Override
    public AttributeValue transformFrom(AtomicBoolean input) {
        return EnhancedAttributeValue.fromBoolean(input.get()).toAttributeValue();
    }

    @Override
    public AtomicBoolean transformTo(AttributeValue input) {
        if (input.bool() != null) {
            return EnhancedAttributeValue.fromBoolean(input.bool()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<AtomicBoolean> {
        private Visitor() {
            super(AtomicBoolean.class, AtomicBooleanAttributeConverter.class);
        }

        @Override
        public AtomicBoolean convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public AtomicBoolean convertBoolean(Boolean value) {
            return new AtomicBoolean(value);
        }
    }
}

