/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.BeginsWithConditional;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.BetweenConditional;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.EqualToConditional;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.SingleKeyItemConditional;

@SdkPublicApi
public interface QueryConditional {
    public static QueryConditional equalTo(Key key) {
        return new EqualToConditional(key);
    }

    public static QueryConditional equalTo(Consumer<Key.Builder> keyConsumer) {
        Key.Builder builder = Key.builder();
        keyConsumer.accept(builder);
        return QueryConditional.equalTo(builder.build());
    }

    public static QueryConditional greaterThan(Key key) {
        return new SingleKeyItemConditional(key, ">");
    }

    public static QueryConditional greaterThan(Consumer<Key.Builder> keyConsumer) {
        Key.Builder builder = Key.builder();
        keyConsumer.accept(builder);
        return QueryConditional.greaterThan(builder.build());
    }

    public static QueryConditional greaterThanOrEqualTo(Key key) {
        return new SingleKeyItemConditional(key, ">=");
    }

    public static QueryConditional greaterThanOrEqualTo(Consumer<Key.Builder> keyConsumer) {
        Key.Builder builder = Key.builder();
        keyConsumer.accept(builder);
        return QueryConditional.greaterThanOrEqualTo(builder.build());
    }

    public static QueryConditional lessThan(Key key) {
        return new SingleKeyItemConditional(key, "<");
    }

    public static QueryConditional lessThan(Consumer<Key.Builder> keyConsumer) {
        Key.Builder builder = Key.builder();
        keyConsumer.accept(builder);
        return QueryConditional.lessThan(builder.build());
    }

    public static QueryConditional lessThanOrEqualTo(Key key) {
        return new SingleKeyItemConditional(key, "<=");
    }

    public static QueryConditional lessThanOrEqualTo(Consumer<Key.Builder> keyConsumer) {
        Key.Builder builder = Key.builder();
        keyConsumer.accept(builder);
        return QueryConditional.lessThanOrEqualTo(builder.build());
    }

    public static QueryConditional between(Key keyFrom, Key keyTo) {
        return new BetweenConditional(keyFrom, keyTo);
    }

    public static QueryConditional between(Consumer<Key.Builder> keyFromConsumer, Consumer<Key.Builder> keyToConsumer) {
        Key.Builder builderFrom = Key.builder();
        Key.Builder builderTo = Key.builder();
        keyFromConsumer.accept(builderFrom);
        keyToConsumer.accept(builderTo);
        return QueryConditional.between(builderFrom.build(), builderTo.build());
    }

    public static QueryConditional beginsWith(Key key) {
        return new BeginsWithConditional(key);
    }

    public static QueryConditional beginsWith(Consumer<Key.Builder> keyConsumer) {
        Key.Builder builder = Key.builder();
        keyConsumer.accept(builder);
        return QueryConditional.beginsWith(builder.build());
    }

    public Expression expression(TableSchema<?> var1, String var2);
}

