/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public class SetAttributeConverter<T extends Collection<?>>
implements AttributeConverter<T> {
    private final Delegate<T, ?> delegate;

    private SetAttributeConverter(Delegate<T, ?> delegate) {
        this.delegate = delegate;
    }

    public static <U> SetAttributeConverter<Set<U>> setConverter(AttributeConverter<U> elementConverter) {
        return SetAttributeConverter.builder(TypeToken.setOf(elementConverter.type())).collectionConstructor(LinkedHashSet::new).elementConverter(elementConverter).build();
    }

    public static <T extends Collection<U>, U> Builder<T, U> builder(TypeToken<T> collectionType) {
        return new Builder(collectionType);
    }

    @Override
    public TypeToken<T> type() {
        return this.delegate.type();
    }

    @Override
    public AttributeValueType attributeValueType() {
        return this.delegate.attributeValueType();
    }

    @Override
    public AttributeValue transformFrom(T input) {
        return this.delegate.transformFrom(input);
    }

    @Override
    public T transformTo(AttributeValue input) {
        return (T)this.delegate.transformTo(input);
    }

    public static final class Builder<T extends Collection<U>, U> {
        private final TypeToken<T> collectionType;
        private Supplier<? extends T> collectionConstructor;
        private AttributeConverter<U> elementConverter;

        private Builder(TypeToken<T> collectionType) {
            this.collectionType = collectionType;
        }

        public Builder<T, U> collectionConstructor(Supplier<? extends T> collectionConstructor) {
            this.collectionConstructor = collectionConstructor;
            return this;
        }

        public Builder<T, U> elementConverter(AttributeConverter<U> elementConverter) {
            this.elementConverter = elementConverter;
            return this;
        }

        public SetAttributeConverter<T> build() {
            return new SetAttributeConverter(new Delegate(this));
        }
    }

    private static final class Delegate<T extends Collection<U>, U>
    implements AttributeConverter<T> {
        private final TypeToken<T> type;
        private final Supplier<? extends T> collectionConstructor;
        private final AttributeConverter<U> elementConverter;
        private final AttributeValueType attributeValueType;

        private Delegate(Builder<T, U> builder) {
            this.type = ((Builder)builder).collectionType;
            this.collectionConstructor = ((Builder)builder).collectionConstructor;
            this.elementConverter = ((Builder)builder).elementConverter;
            this.attributeValueType = this.attributeValueTypeForSet(this.elementConverter);
        }

        @Override
        public TypeToken<T> type() {
            return this.type;
        }

        @Override
        public AttributeValueType attributeValueType() {
            return this.attributeValueType;
        }

        @Override
        public AttributeValue transformFrom(T input) {
            return EnhancedAttributeValue.flatten(input.stream().map(e -> EnhancedAttributeValue.fromAttributeValue(this.elementConverter.transformFrom(e))).collect(Collectors.toList())).toAttributeValue();
        }

        @Override
        public T transformTo(AttributeValue input) {
            return (T)((Collection)EnhancedAttributeValue.fromAttributeValue(input).convert(new TypeConvertingVisitor<T>(this.type.rawClass(), SetAttributeConverter.class){

                @Override
                public T convertSetOfStrings(List<String> value) {
                    return this.convertCollection(value, EnhancedAttributeValue::fromString);
                }

                @Override
                public T convertSetOfNumbers(List<String> value) {
                    return this.convertCollection(value, EnhancedAttributeValue::fromNumber);
                }

                @Override
                public T convertSetOfBytes(List<SdkBytes> value) {
                    return this.convertCollection(value, EnhancedAttributeValue::fromBytes);
                }

                @Override
                public T convertListOfAttributeValues(List<EnhancedAttributeValue> value) {
                    return this.convertCollection(value, Function.identity());
                }

                private <V> T convertCollection(Collection<V> collection, Function<V, EnhancedAttributeValue> transformFrom) {
                    Collection result = (Collection)collectionConstructor.get();
                    collection.stream().map(transformFrom).map(v -> elementConverter.transformTo(v.toAttributeValue())).forEach(result::add);
                    return result;
                }
            }));
        }

        private AttributeValueType attributeValueTypeForSet(AttributeConverter<U> innerType) {
            switch (innerType.attributeValueType()) {
                case N: {
                    return AttributeValueType.NS;
                }
                case S: {
                    return AttributeValueType.SS;
                }
                case B: {
                    return AttributeValueType.BS;
                }
            }
            throw new IllegalArgumentException(String.format("SetAttributeConverter cannot be created with a parameterized type of '%s'. Supported parameterized types must convert to B, S or N DynamoDB AttributeValues.", innerType.type().rawClass()));
        }
    }
}

