/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class ByteArrayAttributeConverter
implements AttributeConverter<byte[]> {
    private static final Visitor VISITOR = new Visitor();

    private ByteArrayAttributeConverter() {
    }

    public static ByteArrayAttributeConverter create() {
        return new ByteArrayAttributeConverter();
    }

    @Override
    public TypeToken<byte[]> type() {
        return TypeToken.of(byte[].class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.B;
    }

    @Override
    public AttributeValue transformFrom(byte[] input) {
        return EnhancedAttributeValue.fromBytes(SdkBytes.fromByteArray((byte[])input)).toAttributeValue();
    }

    @Override
    public byte[] transformTo(AttributeValue input) {
        if (input.b() != null) {
            return EnhancedAttributeValue.fromBytes(input.b()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<byte[]> {
        private Visitor() {
            super(byte[].class, ByteArrayAttributeConverter.class);
        }

        @Override
        public byte[] convertBytes(SdkBytes value) {
            return value.asByteArray();
        }
    }
}

