/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.StaticTableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;

@SdkPublicApi
public final class AttributeTags {
    private static final AttributeTag PRIMARY_PARTITION_KEY_SINGLETON = new KeyAttribute((tableMetadataBuilder, attribute) -> tableMetadataBuilder.addIndexPartitionKey(TableMetadata.primaryIndexName(), ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType()));
    private static final AttributeTag PRIMARY_SORT_KEY_SINGLETON = new KeyAttribute((tableMetadataBuilder, attribute) -> tableMetadataBuilder.addIndexSortKey(TableMetadata.primaryIndexName(), ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType()));

    private AttributeTags() {
    }

    public static AttributeTag primaryPartitionKey() {
        return PRIMARY_PARTITION_KEY_SINGLETON;
    }

    public static AttributeTag primarySortKey() {
        return PRIMARY_SORT_KEY_SINGLETON;
    }

    public static AttributeTag secondaryPartitionKey(String indexName) {
        return new KeyAttribute((tableMetadataBuilder, attribute) -> tableMetadataBuilder.addIndexPartitionKey(indexName, ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType()));
    }

    public static AttributeTag secondarySortKey(String indexName) {
        return new KeyAttribute((tableMetadataBuilder, attribute) -> tableMetadataBuilder.addIndexSortKey(indexName, ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType()));
    }

    public static AttributeTag secondaryPartitionKey(Collection<String> indexNames) {
        return new KeyAttribute((tableMetadataBuilder, attribute) -> indexNames.forEach(indexName -> tableMetadataBuilder.addIndexPartitionKey((String)indexName, ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType())));
    }

    public static AttributeTag secondarySortKey(Collection<String> indexNames) {
        return new KeyAttribute((tableMetadataBuilder, attribute) -> indexNames.forEach(indexName -> tableMetadataBuilder.addIndexSortKey((String)indexName, ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType())));
    }

    private static class AttributeAndType {
        private final String attributeName;
        private final AttributeValueType attributeValueType;

        private AttributeAndType(String attributeName, AttributeValueType attributeValueType) {
            this.attributeName = attributeName;
            this.attributeValueType = attributeValueType;
        }

        private String getAttributeName() {
            return this.attributeName;
        }

        private AttributeValueType getAttributeValueType() {
            return this.attributeValueType;
        }
    }

    private static class KeyAttribute
    extends AttributeTag {
        private final BiConsumer<StaticTableMetadata.Builder, AttributeAndType> tableMetadataKeySetter;

        private KeyAttribute(BiConsumer<StaticTableMetadata.Builder, AttributeAndType> tableMetadataKeySetter) {
            this.tableMetadataKeySetter = tableMetadataKeySetter;
        }

        @Override
        protected boolean isKeyAttribute() {
            return true;
        }

        @Override
        public Map<String, Object> customMetadataForAttribute(String attributeName, AttributeValueType attributeValueType) {
            return Collections.emptyMap();
        }

        @Override
        public void setTableMetadataForAttribute(String attributeName, AttributeValueType attributeValueType, StaticTableMetadata.Builder tableMetadataBuilder) {
            if (attributeValueType.scalarAttributeType() == null) {
                throw new IllegalArgumentException(String.format("Attribute '%s' of type %s is not a suitable type to be used as a key.", attributeName, attributeValueType.name()));
            }
            this.tableMetadataKeySetter.accept(tableMetadataBuilder, new AttributeAndType(attributeName, attributeValueType));
        }
    }
}

