/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.BeanAttributeGetter;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.BeanAttributeSetter;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.BeanConstructor;
import software.amazon.awssdk.enhanced.dynamodb.mapper.Attribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeType;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeTypes;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.BeanTableSchemaAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbBean;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbFlatten;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbIgnore;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public final class BeanTableSchema<T>
implements TableSchema<T> {
    private static final String ATTRIBUTE_TAG_STATIC_SUPPLIER_NAME = "attributeTagFor";
    private static final Map<TypeToken<?>, AttributeType<?>> ATTRIBUTE_TYPES_MAP;
    private final StaticTableSchema<T> wrappedTableSchema;
    private final Class<T> beanClass;

    private BeanTableSchema(StaticTableSchema<T> staticTableSchema, Class<T> beanClass) {
        this.wrappedTableSchema = staticTableSchema;
        this.beanClass = beanClass;
    }

    public static <T> BeanTableSchema<T> create(Class<T> beanClass) {
        return new BeanTableSchema<T>(BeanTableSchema.createStaticTableSchema(beanClass), beanClass);
    }

    public Class<T> beanClass() {
        return this.beanClass;
    }

    @Override
    public T mapToItem(Map<String, AttributeValue> attributeMap) {
        return this.wrappedTableSchema.mapToItem(attributeMap);
    }

    @Override
    public Map<String, AttributeValue> itemToMap(T item, boolean ignoreNulls) {
        return this.wrappedTableSchema.itemToMap(item, ignoreNulls);
    }

    @Override
    public Map<String, AttributeValue> itemToMap(T item, Collection<String> attributes) {
        return this.wrappedTableSchema.itemToMap(item, attributes);
    }

    @Override
    public AttributeValue attributeValue(T item, String key) {
        return this.wrappedTableSchema.attributeValue(item, key);
    }

    @Override
    public TableMetadata tableMetadata() {
        return this.wrappedTableSchema.tableMetadata();
    }

    private static <T> StaticTableSchema<T> createStaticTableSchema(Class<T> beanClass) {
        BeanInfo beanInfo;
        DynamoDbBean dynamoDbBean = beanClass.getAnnotation(DynamoDbBean.class);
        if (dynamoDbBean == null) {
            throw new IllegalArgumentException("A DynamoDb bean class must be annotated with @DynamoDbBean");
        }
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
        Supplier<T> newObjectSupplier = BeanTableSchema.newObjectSupplierForClass(beanClass);
        StaticTableSchema.Builder builder = StaticTableSchema.builder(beanClass).newItemSupplier(newObjectSupplier);
        ArrayList attributes = new ArrayList();
        Arrays.stream(beanInfo.getPropertyDescriptors()).filter(BeanTableSchema::isMappableProperty).forEach(propertyDescriptor -> {
            DynamoDbFlatten dynamoDbFlatten = BeanTableSchema.propertyAnnotation(propertyDescriptor, DynamoDbFlatten.class);
            if (dynamoDbFlatten != null) {
                builder.flatten(BeanTableSchema.createStaticTableSchema(dynamoDbFlatten.dynamoDbBeanClass()), BeanTableSchema.getterForProperty(propertyDescriptor, beanClass), BeanTableSchema.setterForProperty(propertyDescriptor, beanClass));
            } else {
                Attribute.AttributeSupplier attributeSupplier = Attribute.create(BeanTableSchema.attributeNameForProperty(propertyDescriptor), BeanTableSchema.getterForProperty(propertyDescriptor, beanClass), BeanTableSchema.setterForProperty(propertyDescriptor, beanClass), BeanTableSchema.attributeTypeForProperty(propertyDescriptor));
                BeanTableSchema.addTagsToAttribute(attributeSupplier, propertyDescriptor);
                attributes.add(attributeSupplier);
            }
        });
        builder.attributes(attributes);
        return builder.build();
    }

    private static void addTagsToAttribute(Attribute.AttributeSupplier<?> attributeSupplier, PropertyDescriptor propertyDescriptor) {
        BeanTableSchema.propertyAnnotations(propertyDescriptor).forEach(annotation -> {
            BeanTableSchemaAttributeTag beanTableSchemaAttributeTag = annotation.annotationType().getAnnotation(BeanTableSchemaAttributeTag.class);
            if (beanTableSchemaAttributeTag != null) {
                AttributeTag attributeTag;
                Method tagMethod;
                Class<?> tagClass = beanTableSchemaAttributeTag.value();
                try {
                    tagMethod = tagClass.getDeclaredMethod(ATTRIBUTE_TAG_STATIC_SUPPLIER_NAME, annotation.annotationType());
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(String.format("Could not find a static method named '%s' on class '%s' that returns an AttributeTag for annotation '%s'", ATTRIBUTE_TAG_STATIC_SUPPLIER_NAME, tagClass, annotation.annotationType()), e);
                }
                if (!Modifier.isStatic(tagMethod.getModifiers())) {
                    throw new RuntimeException(String.format("Could not find a static method named '%s' on class '%s' that returns an AttributeTag for annotation '%s'", ATTRIBUTE_TAG_STATIC_SUPPLIER_NAME, tagClass, annotation.annotationType()));
                }
                try {
                    attributeTag = (AttributeTag)tagMethod.invoke(null, annotation);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(String.format("Could not invoke method to create AttributeTag for annotation '%s' on class '%s'.", annotation.annotationType(), tagClass), e);
                }
                attributeSupplier.as(attributeTag);
            }
        });
    }

    private static <R> Supplier<R> newObjectSupplierForClass(Class<R> clazz) {
        try {
            return BeanConstructor.create(clazz, clazz.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Class '%s' appears to have no default constructor thus cannot be used with the BeanTableSchema", clazz), e);
        }
    }

    private static <T, R> Function<T, R> getterForProperty(PropertyDescriptor propertyDescriptor, Class<T> beanClass) {
        Method readMethod = propertyDescriptor.getReadMethod();
        return BeanAttributeGetter.create(beanClass, readMethod);
    }

    private static <T, R> BiConsumer<T, R> setterForProperty(PropertyDescriptor propertyDescriptor, Class<T> beanClass) {
        Method writeMethod = propertyDescriptor.getWriteMethod();
        return BeanAttributeSetter.create(beanClass, writeMethod);
    }

    private static String attributeNameForProperty(PropertyDescriptor propertyDescriptor) {
        DynamoDbAttribute dynamoDbAttribute = BeanTableSchema.propertyAnnotation(propertyDescriptor, DynamoDbAttribute.class);
        if (dynamoDbAttribute != null) {
            return dynamoDbAttribute.value();
        }
        return propertyDescriptor.getName();
    }

    private static <R> AttributeType<R> attributeTypeForProperty(PropertyDescriptor propertyDescriptor) {
        Type propertyType = propertyDescriptor.getReadMethod().getGenericReturnType();
        return BeanTableSchema.attributeTypeForProperty(propertyType);
    }

    private static <R> AttributeType<R> attributeTypeForProperty(Type type) {
        Class clazz;
        AttributeType<R> attributeType;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (List.class.equals((Object)parameterizedType.getRawType())) {
                return BeanTableSchema.attributeTypeForList(parameterizedType);
            }
            if (Map.class.equals((Object)parameterizedType.getRawType())) {
                return BeanTableSchema.attributeTypeForMap(parameterizedType);
            }
        }
        if ((attributeType = BeanTableSchema.lookupAttributeType(type)) != null) {
            return attributeType;
        }
        if (type instanceof Class && (clazz = (Class)type).getAnnotation(DynamoDbBean.class) != null) {
            return BeanTableSchema.attributeTypeForDocument(clazz);
        }
        throw new RuntimeException(String.format("No matching converter could be found for type '%s' on bean class.", type.getTypeName()));
    }

    private static <R> AttributeType<R> lookupAttributeType(Type type) {
        return ATTRIBUTE_TYPES_MAP.get(TypeToken.of(type));
    }

    private static <R> AttributeType<R> attributeTypeForDocument(Class<?> documentClass) {
        return AttributeTypes.documentMapType(BeanTableSchema.createStaticTableSchema(documentClass));
    }

    private static <R> AttributeType<R> attributeTypeForList(ParameterizedType parameterizedType) {
        Type parameterType = parameterizedType.getActualTypeArguments()[0];
        return AttributeTypes.listType(BeanTableSchema.attributeTypeForProperty(parameterType));
    }

    private static <R> AttributeType<R> attributeTypeForMap(ParameterizedType parameterizedType) {
        Type keyType = parameterizedType.getActualTypeArguments()[0];
        Type valueType = parameterizedType.getActualTypeArguments()[1];
        if (!String.class.equals((Object)keyType)) {
            throw new IllegalArgumentException(String.format("No matching converter could be found for type '%s' on bean class: Maps must have a key type of 'String'.", keyType.getTypeName()));
        }
        return AttributeTypes.mapType(BeanTableSchema.attributeTypeForProperty(valueType));
    }

    private static boolean isMappableProperty(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getReadMethod() != null && propertyDescriptor.getWriteMethod() != null && BeanTableSchema.propertyAnnotation(propertyDescriptor, DynamoDbIgnore.class) == null;
    }

    private static <R extends Annotation> R propertyAnnotation(PropertyDescriptor propertyDescriptor, Class<R> annotationType) {
        R getterAnnotation = propertyDescriptor.getReadMethod().getAnnotation(annotationType);
        R setterAnnotation = propertyDescriptor.getWriteMethod().getAnnotation(annotationType);
        if (getterAnnotation != null) {
            return getterAnnotation;
        }
        return setterAnnotation;
    }

    private static List<? extends Annotation> propertyAnnotations(PropertyDescriptor propertyDescriptor) {
        return Stream.concat(Arrays.stream(propertyDescriptor.getReadMethod().getAnnotations()), Arrays.stream(propertyDescriptor.getWriteMethod().getAnnotations())).collect(Collectors.toList());
    }

    static {
        HashMap<TypeToken<Object>, AttributeType<Object>> map = new HashMap<TypeToken<Object>, AttributeType<Object>>();
        map.put(TypeToken.of(String.class), AttributeTypes.stringType());
        map.put(TypeToken.of(Boolean.class), AttributeTypes.booleanType());
        map.put(TypeToken.of(Boolean.TYPE), AttributeTypes.booleanType());
        map.put(TypeToken.of(Integer.class), AttributeTypes.integerNumberType());
        map.put(TypeToken.of(Integer.TYPE), AttributeTypes.integerNumberType());
        map.put(TypeToken.of(Long.class), AttributeTypes.longNumberType());
        map.put(TypeToken.of(Long.TYPE), AttributeTypes.longNumberType());
        map.put(TypeToken.of(Short.class), AttributeTypes.shortNumberType());
        map.put(TypeToken.of(Short.TYPE), AttributeTypes.shortNumberType());
        map.put(TypeToken.of(Byte.class), AttributeTypes.byteNumberType());
        map.put(TypeToken.of(Byte.TYPE), AttributeTypes.byteNumberType());
        map.put(TypeToken.of(Double.class), AttributeTypes.doubleNumberType());
        map.put(TypeToken.of(Double.TYPE), AttributeTypes.doubleNumberType());
        map.put(TypeToken.of(Float.class), AttributeTypes.floatNumberType());
        map.put(TypeToken.of(Float.TYPE), AttributeTypes.floatNumberType());
        map.put(TypeToken.of(SdkBytes.class), AttributeTypes.binaryType());
        map.put(TypeToken.setOf(String.class), AttributeTypes.stringSetType());
        map.put(TypeToken.setOf(Integer.class), AttributeTypes.integerNumberSetType());
        map.put(TypeToken.setOf(Long.class), AttributeTypes.longNumberSetType());
        map.put(TypeToken.setOf(Short.class), AttributeTypes.shortNumberSetType());
        map.put(TypeToken.setOf(Byte.class), AttributeTypes.byteNumberSetType());
        map.put(TypeToken.setOf(Double.class), AttributeTypes.doubleNumberSetType());
        map.put(TypeToken.setOf(Float.class), AttributeTypes.floatNumberSetType());
        map.put(TypeToken.setOf(SdkBytes.class), AttributeTypes.binarySetType());
        ATTRIBUTE_TYPES_MAP = Collections.unmodifiableMap(map);
    }
}

