/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableReadOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.GetItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.GetItemOperation;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItem;

@SdkPublicApi
public final class TransactGetItemsEnhancedRequest {
    private final List<TransactGetItem> transactGetItems;

    private TransactGetItemsEnhancedRequest(Builder builder) {
        this.transactGetItems = Utils.getItemsFromSupplier(builder.itemSupplierList);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<TransactGetItem> transactGetItems() {
        return this.transactGetItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactGetItemsEnhancedRequest that = (TransactGetItemsEnhancedRequest)o;
        return this.transactGetItems != null ? this.transactGetItems.equals(that.transactGetItems) : that.transactGetItems == null;
    }

    public int hashCode() {
        return this.transactGetItems != null ? this.transactGetItems.hashCode() : 0;
    }

    public static final class Builder {
        private List<Supplier<TransactGetItem>> itemSupplierList = new ArrayList<Supplier<TransactGetItem>>();

        private Builder() {
        }

        public <T> Builder addGetItem(MappedTableResource<T> mappedTableResource, GetItemEnhancedRequest request) {
            this.itemSupplierList.add(() -> this.generateTransactWriteItem(mappedTableResource, GetItemOperation.create(request)));
            return this;
        }

        public <T> Builder addGetItem(MappedTableResource<T> mappedTableResource, Consumer<GetItemEnhancedRequest.Builder> requestConsumer) {
            GetItemEnhancedRequest.Builder builder = GetItemEnhancedRequest.builder();
            requestConsumer.accept(builder);
            return this.addGetItem(mappedTableResource, builder.build());
        }

        public TransactGetItemsEnhancedRequest build() {
            return new TransactGetItemsEnhancedRequest(this);
        }

        private <T> TransactGetItem generateTransactWriteItem(MappedTableResource<T> mappedTableResource, TransactableReadOperation<T> generator) {
            return generator.generateTransactGetItem(mappedTableResource.tableSchema(), OperationContext.create(mappedTableResource.tableName()), mappedTableResource.mapperExtension());
        }
    }
}

