/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.PaginatedOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkPublicApi
public interface PaginatedIndexOperation<ItemT, RequestT, ResponseT, ResultT>
extends PaginatedOperation<ItemT, RequestT, ResponseT, ResultT> {
    default public SdkIterable<ResultT> executeOnSecondaryIndex(TableSchema<ItemT> tableSchema, String tableName, String indexName, MapperExtension mapperExtension, DynamoDbClient dynamoDbClient) {
        OperationContext context = OperationContext.create(tableName, indexName);
        return this.execute(tableSchema, context, mapperExtension, dynamoDbClient);
    }

    default public SdkPublisher<ResultT> executeOnSecondaryIndexAsync(TableSchema<ItemT> tableSchema, String tableName, String indexName, MapperExtension mapperExtension, DynamoDbAsyncClient dynamoDbAsyncClient) {
        OperationContext context = OperationContext.create(tableName, indexName);
        return this.executeAsync(tableSchema, context, mapperExtension, dynamoDbAsyncClient);
    }
}

