/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.BatchableWriteOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.DeleteItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.PutItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.DeleteItemOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.PutItemOperation;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkPublicApi
public final class WriteBatch {
    private final String tableName;
    private final List<WriteRequest> writeRequests;

    private WriteBatch(BuilderImpl<?> builder) {
        this.tableName = ((BuilderImpl)builder).mappedTableResource.tableName();
        this.writeRequests = Collections.unmodifiableList(((BuilderImpl)builder).itemSupplierList.stream().map(Supplier::get).collect(Collectors.toList()));
    }

    public static <T> Builder<T> builder(Class<? extends T> itemClass) {
        return new BuilderImpl();
    }

    public String tableName() {
        return this.tableName;
    }

    public Collection<WriteRequest> writeRequests() {
        return this.writeRequests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteBatch that = (WriteBatch)o;
        if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) {
            return false;
        }
        return this.writeRequests != null ? this.writeRequests.equals(that.writeRequests) : that.writeRequests == null;
    }

    public int hashCode() {
        int result = this.tableName != null ? this.tableName.hashCode() : 0;
        result = 31 * result + (this.writeRequests != null ? this.writeRequests.hashCode() : 0);
        return result;
    }

    private static final class BuilderImpl<T>
    implements Builder<T> {
        private List<Supplier<WriteRequest>> itemSupplierList = new ArrayList<Supplier<WriteRequest>>();
        private MappedTableResource<T> mappedTableResource;

        private BuilderImpl() {
        }

        @Override
        public Builder<T> mappedTableResource(MappedTableResource<T> mappedTableResource) {
            this.mappedTableResource = mappedTableResource;
            return this;
        }

        @Override
        public Builder<T> addDeleteItem(DeleteItemEnhancedRequest<T> request) {
            this.itemSupplierList.add(() -> this.generateWriteRequest(() -> this.mappedTableResource, DeleteItemOperation.create(request)));
            return this;
        }

        @Override
        public Builder<T> addPutItem(PutItemEnhancedRequest<T> request) {
            this.itemSupplierList.add(() -> this.generateWriteRequest(() -> this.mappedTableResource, PutItemOperation.create(request)));
            return this;
        }

        @Override
        public WriteBatch build() {
            return new WriteBatch(this);
        }

        private WriteRequest generateWriteRequest(Supplier<MappedTableResource<T>> mappedTableResourceSupplier, BatchableWriteOperation<T> operation) {
            return operation.generateWriteRequest(mappedTableResourceSupplier.get().tableSchema(), OperationContext.create(mappedTableResourceSupplier.get().tableName()), mappedTableResourceSupplier.get().mapperExtension());
        }
    }

    public static interface Builder<T> {
        public Builder<T> mappedTableResource(MappedTableResource<T> var1);

        public Builder<T> addDeleteItem(DeleteItemEnhancedRequest<T> var1);

        public Builder<T> addPutItem(PutItemEnhancedRequest<T> var1);

        public WriteBatch build();
    }
}

