/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;

@SdkPublicApi
public class GlobalSecondaryIndex {
    private final String indexName;
    private final Projection projection;
    private final ProvisionedThroughput provisionedThroughput;

    private GlobalSecondaryIndex(Builder builder) {
        this.indexName = builder.indexName;
        this.projection = builder.projection;
        this.provisionedThroughput = builder.provisionedThroughput;
    }

    public static GlobalSecondaryIndex create(String indexName, Projection projection, ProvisionedThroughput provisionedThroughput) {
        return GlobalSecondaryIndex.builder().indexName(indexName).projection(projection).provisionedThroughput(provisionedThroughput).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return GlobalSecondaryIndex.builder().indexName(this.indexName).projection(this.projection).provisionedThroughput(this.provisionedThroughput);
    }

    public String indexName() {
        return this.indexName;
    }

    public Projection projection() {
        return this.projection;
    }

    public ProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalSecondaryIndex that = (GlobalSecondaryIndex)o;
        if (this.indexName != null ? !this.indexName.equals(that.indexName) : that.indexName != null) {
            return false;
        }
        if (this.projection != null ? !this.projection.equals((Object)that.projection) : that.projection != null) {
            return false;
        }
        return this.provisionedThroughput != null ? this.provisionedThroughput.equals((Object)that.provisionedThroughput) : that.provisionedThroughput == null;
    }

    public int hashCode() {
        int result = this.indexName != null ? this.indexName.hashCode() : 0;
        result = 31 * result + (this.projection != null ? this.projection.hashCode() : 0);
        result = 31 * result + (this.provisionedThroughput != null ? this.provisionedThroughput.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private String indexName;
        private Projection projection;
        private ProvisionedThroughput provisionedThroughput;

        private Builder() {
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder projection(Projection projection) {
            this.projection = projection;
            return this;
        }

        public Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public GlobalSecondaryIndex build() {
            return new GlobalSecondaryIndex(this);
        }
    }
}

