/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableWriteOperation;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;

@SdkPublicApi
public class WriteTransaction<T> {
    private final MappedTableResource<T> mappedTableResource;
    private final TransactableWriteOperation<T> writeOperation;

    private WriteTransaction(Builder<T> builder) {
        this.mappedTableResource = ((Builder)builder).mappedTableResource;
        this.writeOperation = ((Builder)builder).writeOperation;
    }

    public static <T> WriteTransaction<T> create(MappedTableResource<T> mappedTableResource, TransactableWriteOperation<T> writeOperation) {
        return new Builder<T>().mappedTableResource(mappedTableResource).writeOperation(writeOperation).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return new Builder<T>().mappedTableResource(this.mappedTableResource).writeOperation(this.writeOperation);
    }

    public MappedTableResource<T> mappedTableResource() {
        return this.mappedTableResource;
    }

    public TransactableWriteOperation<T> writeOperation() {
        return this.writeOperation;
    }

    public TransactWriteItem generateTransactWriteItem() {
        return this.writeOperation.generateTransactWriteItem(this.mappedTableResource.tableSchema(), OperationContext.create(this.mappedTableResource.tableName()), this.mappedTableResource.mapperExtension());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteTransaction that = (WriteTransaction)o;
        if (this.mappedTableResource != null ? !this.mappedTableResource.equals(that.mappedTableResource) : that.mappedTableResource != null) {
            return false;
        }
        return this.writeOperation != null ? this.writeOperation.equals(that.writeOperation) : that.writeOperation == null;
    }

    public int hashCode() {
        int result = this.mappedTableResource != null ? this.mappedTableResource.hashCode() : 0;
        result = 31 * result + (this.writeOperation != null ? this.writeOperation.hashCode() : 0);
        return result;
    }

    public static final class Builder<T> {
        private MappedTableResource<T> mappedTableResource;
        private TransactableWriteOperation<T> writeOperation;

        private Builder() {
        }

        public Builder<T> mappedTableResource(MappedTableResource<T> mappedTableResource) {
            this.mappedTableResource = mappedTableResource;
            return this;
        }

        public Builder<T> writeOperation(TransactableWriteOperation<T> writeOperation) {
            this.writeOperation = writeOperation;
            return this;
        }

        public WriteTransaction<T> build() {
            return new WriteTransaction(this);
        }
    }
}

