/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.BatchableReadOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;

@SdkPublicApi
public class ReadBatch<T> {
    private final MappedTableResource<T> mappedTableResource;
    private final List<BatchableReadOperation> readOperations;

    private ReadBatch(Builder<T> builder) {
        this.mappedTableResource = ((Builder)builder).mappedTableResource;
        this.readOperations = Collections.unmodifiableList(((Builder)builder).readOperations);
    }

    public static <T> ReadBatch<T> create(MappedTableResource<T> mappedTableResource, Collection<BatchableReadOperation> readOperations) {
        return new Builder<T>().mappedTableResource(mappedTableResource).readOperations(readOperations).build();
    }

    public static <T> ReadBatch<T> create(MappedTableResource<T> mappedTableResource, BatchableReadOperation ... readOperations) {
        return new Builder<T>().mappedTableResource(mappedTableResource).readOperations(readOperations).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return new Builder<T>().mappedTableResource(this.mappedTableResource).readOperations(this.readOperations);
    }

    public MappedTableResource<T> mappedTableResource() {
        return this.mappedTableResource;
    }

    public Collection<BatchableReadOperation> readOperations() {
        return this.readOperations;
    }

    public KeysAndAttributes generateKeysAndAttributes() {
        AtomicReference consistentRead = new AtomicReference();
        AtomicBoolean firstRecord = new AtomicBoolean(true);
        List keys = this.readOperations.stream().peek(operation -> {
            if (firstRecord.getAndSet(false)) {
                consistentRead.set(operation.consistentRead());
            } else if (!ReadBatch.compareNullableBooleans((Boolean)consistentRead.get(), operation.consistentRead())) {
                throw new IllegalArgumentException("All batchable read requests for the same table must have the same 'consistentRead' setting.");
            }
        }).map(BatchableReadOperation::key).map(key -> key.keyMap(this.mappedTableResource.tableSchema(), TableMetadata.primaryIndexName())).collect(Collectors.toList());
        return (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).consistentRead((Boolean)consistentRead.get()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadBatch readBatch = (ReadBatch)o;
        if (this.mappedTableResource != null ? !this.mappedTableResource.equals(readBatch.mappedTableResource) : readBatch.mappedTableResource != null) {
            return false;
        }
        return this.readOperations != null ? this.readOperations.equals(readBatch.readOperations) : readBatch.readOperations == null;
    }

    public int hashCode() {
        int result = this.mappedTableResource != null ? this.mappedTableResource.hashCode() : 0;
        result = 31 * result + (this.readOperations != null ? this.readOperations.hashCode() : 0);
        return result;
    }

    private static boolean compareNullableBooleans(Boolean one, Boolean two) {
        if (one == null && two == null) {
            return true;
        }
        if (one != null) {
            return one.equals(two);
        }
        return false;
    }

    public static final class Builder<T> {
        private MappedTableResource<T> mappedTableResource;
        private List<BatchableReadOperation> readOperations;

        private Builder() {
        }

        public Builder<T> mappedTableResource(MappedTableResource<T> mappedTableResource) {
            this.mappedTableResource = mappedTableResource;
            return this;
        }

        public Builder<T> readOperations(Collection<BatchableReadOperation> readOperations) {
            this.readOperations = new ArrayList<BatchableReadOperation>(readOperations);
            return this;
        }

        public Builder<T> readOperations(BatchableReadOperation ... readOperations) {
            this.readOperations = Arrays.asList(readOperations);
            return this;
        }

        public Builder addReadOperation(BatchableReadOperation readOperation) {
            if (this.readOperations == null) {
                this.readOperations = new ArrayList<BatchableReadOperation>();
            }
            this.readOperations.add(readOperation);
            return this;
        }

        public ReadBatch<T> build() {
            return new ReadBatch(this);
        }
    }
}

