/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.dynamodb.model.Projection;

@SdkPublicApi
public class LocalSecondaryIndex {
    private final String indexName;
    private final Projection projection;

    private LocalSecondaryIndex(String indexName, Projection projection) {
        this.indexName = indexName;
        this.projection = projection;
    }

    public static LocalSecondaryIndex create(String indexName, Projection projection) {
        return new LocalSecondaryIndex(indexName, projection);
    }

    public String indexName() {
        return this.indexName;
    }

    public Projection projection() {
        return this.projection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalSecondaryIndex that = (LocalSecondaryIndex)o;
        if (this.indexName != null ? !this.indexName.equals(that.indexName) : that.indexName != null) {
            return false;
        }
        return this.projection != null ? this.projection.equals((Object)that.projection) : that.projection == null;
    }

    public int hashCode() {
        int result = this.indexName != null ? this.indexName.hashCode() : 0;
        result = 31 * result + (this.projection != null ? this.projection.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private String indexName;
        private Projection projection;

        private Builder() {
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder projection(Projection projection) {
            this.projection = projection;
            return this;
        }

        public LocalSecondaryIndex build() {
            return new LocalSecondaryIndex(this.indexName, this.projection);
        }
    }
}

