/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.ReadTransaction;

@SdkPublicApi
public class TransactGetItemsEnhancedRequest {
    private final List<ReadTransaction> readTransactions;

    private TransactGetItemsEnhancedRequest(Builder builder) {
        this.readTransactions = Collections.unmodifiableList(builder.readTransactions);
    }

    public static TransactGetItemsEnhancedRequest create(Collection<ReadTransaction> transactGetRequests) {
        return TransactGetItemsEnhancedRequest.builder().readTransactions(transactGetRequests).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().readTransactions(this.readTransactions);
    }

    public List<ReadTransaction> readTransactions() {
        return this.readTransactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactGetItemsEnhancedRequest that = (TransactGetItemsEnhancedRequest)o;
        return this.readTransactions != null ? this.readTransactions.equals(that.readTransactions) : that.readTransactions == null;
    }

    public int hashCode() {
        return this.readTransactions != null ? this.readTransactions.hashCode() : 0;
    }

    public static final class Builder {
        private List<ReadTransaction> readTransactions;

        private Builder() {
        }

        public Builder readTransactions(Collection<ReadTransaction> readTransactions) {
            this.readTransactions = new ArrayList<ReadTransaction>(readTransactions);
            return this;
        }

        public Builder readTransactions(ReadTransaction ... readTransactions) {
            this.readTransactions = Arrays.asList(readTransactions);
            return this;
        }

        public Builder addWriteBatch(ReadTransaction readTransaction) {
            if (this.readTransactions == null) {
                this.readTransactions = new ArrayList<ReadTransaction>();
            }
            this.readTransactions.add(readTransaction);
            return this;
        }

        public TransactGetItemsEnhancedRequest build() {
            return new TransactGetItemsEnhancedRequest(this);
        }
    }
}

