/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkPublicApi
public class BatchWriteResult {
    private final Map<String, List<WriteRequest>> unprocessedRequests;

    private BatchWriteResult(Builder builder) {
        this.unprocessedRequests = Collections.unmodifiableMap(builder.unprocessedRequests);
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> List<T> unprocessedPutItemsForTable(MappedTable<T> mappedTable) {
        List writeRequests = this.unprocessedRequests.getOrDefault(mappedTable.tableName(), Collections.emptyList());
        return writeRequests.stream().filter(writeRequest -> writeRequest.putRequest() != null).map(WriteRequest::putRequest).map(PutRequest::item).map(item -> Utils.readAndTransformSingleItem(item, mappedTable.tableSchema(), OperationContext.create(mappedTable.tableName()), mappedTable.mapperExtension())).collect(Collectors.toList());
    }

    public <T> List<T> unprocessedDeleteItemsForTable(MappedTable<T> mappedTable) {
        List writeRequests = this.unprocessedRequests.getOrDefault(mappedTable.tableName(), Collections.emptyList());
        return writeRequests.stream().filter(writeRequest -> writeRequest.deleteRequest() != null).map(WriteRequest::deleteRequest).map(DeleteRequest::key).map(itemMap -> mappedTable.tableSchema().mapToItem((Map<String, AttributeValue>)itemMap)).collect(Collectors.toList());
    }

    public static final class Builder {
        private Map<String, List<WriteRequest>> unprocessedRequests;

        private Builder() {
        }

        public Builder unprocessedRequests(Map<String, List<WriteRequest>> unprocessedRequests) {
            this.unprocessedRequests = unprocessedRequests.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableList((List)entry.getValue())));
            return this;
        }

        public BatchWriteResult build() {
            return new BatchWriteResult(this);
        }
    }
}

