/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.core;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Key;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Page;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.extensions.ReadModification;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public final class Utils {
    private Utils() {
    }

    public static String cleanAttributeName(String key) {
        boolean somethingChanged = false;
        char[] chars = key.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '*' && chars[i] != '.' && chars[i] != '-') continue;
            chars[i] = 95;
            somethingChanged = true;
        }
        return somethingChanged ? new String(chars) : key;
    }

    public static <T> T readAndTransformSingleItem(Map<String, AttributeValue> itemMap, TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        ReadModification readModification;
        if (itemMap == null || itemMap.isEmpty()) {
            return null;
        }
        if (mapperExtension != null && (readModification = mapperExtension.afterRead(itemMap, operationContext, tableSchema.tableMetadata())) != null && readModification.transformedItem() != null) {
            return tableSchema.mapToItem(readModification.transformedItem());
        }
        return tableSchema.mapToItem(itemMap);
    }

    public static <ResponseT, ItemT> Page<ItemT> readAndTransformPaginatedItems(ResponseT response, TableSchema<ItemT> tableSchema, OperationContext operationContext, MapperExtension mapperExtension, Function<ResponseT, List<Map<String, AttributeValue>>> getItems, Function<ResponseT, Map<String, AttributeValue>> getLastEvaluatedKey) {
        if (getLastEvaluatedKey.apply(response) == null || getLastEvaluatedKey.apply(response).isEmpty()) {
            return Page.create(getItems.apply(response).stream().map(itemMap -> Utils.readAndTransformSingleItem(itemMap, tableSchema, operationContext, mapperExtension)).collect(Collectors.toList()));
        }
        return Page.create(getItems.apply(response).stream().map(itemMap -> Utils.readAndTransformSingleItem(itemMap, tableSchema, operationContext, mapperExtension)).collect(Collectors.toList()), getLastEvaluatedKey.apply(response));
    }

    public static <T> Key createKeyFromItem(T item, TableSchema<T> tableSchema, String indexName) {
        String partitionKeyName = tableSchema.tableMetadata().indexPartitionKey(indexName);
        Optional<String> sortKeyName = tableSchema.tableMetadata().indexSortKey(indexName);
        AttributeValue partitionKeyValue = tableSchema.attributeValue(item, partitionKeyName);
        Optional<AttributeValue> sortKeyValue = sortKeyName.map(key -> tableSchema.attributeValue(item, (String)key));
        return sortKeyValue.map(attributeValue -> Key.create(partitionKeyValue, attributeValue)).orElseGet(() -> Key.create(partitionKeyValue));
    }
}

