/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.BatchableWriteOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkPublicApi
public class WriteBatch<T> {
    private final MappedTableResource<T> mappedTableResource;
    private final Collection<BatchableWriteOperation<T>> writeOperations;

    private WriteBatch(MappedTableResource<T> mappedTableResource, Collection<BatchableWriteOperation<T>> writeOperations) {
        this.mappedTableResource = mappedTableResource;
        this.writeOperations = writeOperations;
    }

    public static <T> WriteBatch<T> of(MappedTableResource<T> mappedTableResource, Collection<BatchableWriteOperation<T>> writeOperations) {
        return new WriteBatch<T>(mappedTableResource, writeOperations);
    }

    @SafeVarargs
    public static <T> WriteBatch<T> of(MappedTableResource<T> mappedTableResource, BatchableWriteOperation<T> ... writeOperations) {
        return new WriteBatch<T>(mappedTableResource, Arrays.asList(writeOperations));
    }

    public MappedTableResource<T> mappedTableResource() {
        return this.mappedTableResource;
    }

    public Collection<BatchableWriteOperation<T>> writeOperations() {
        return this.writeOperations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteBatch that = (WriteBatch)o;
        if (this.mappedTableResource != null ? !this.mappedTableResource.equals(that.mappedTableResource) : that.mappedTableResource != null) {
            return false;
        }
        return this.writeOperations != null ? this.writeOperations.equals(that.writeOperations) : that.writeOperations == null;
    }

    public int hashCode() {
        int result = this.mappedTableResource != null ? this.mappedTableResource.hashCode() : 0;
        result = 31 * result + (this.writeOperations != null ? this.writeOperations.hashCode() : 0);
        return result;
    }

    void addWriteRequestsToMap(Map<String, Collection<WriteRequest>> writeRequestMap) {
        Collection writeRequestsForTable = writeRequestMap.computeIfAbsent(this.getTableName(), ignored -> new ArrayList());
        writeRequestsForTable.addAll(this.writeOperations.stream().map(writeOperation -> writeOperation.generateWriteRequest(this.mappedTableResource.tableSchema(), OperationContext.of(this.mappedTableResource.tableName()), this.mappedTableResource.mapperExtension())).collect(Collectors.toList()));
    }

    String getTableName() {
        return this.mappedTableResource.tableName();
    }
}

