/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableWriteOperation;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;

@SdkPublicApi
public class WriteTransaction<T> {
    private final MappedTable<T> mappedTable;
    private final TransactableWriteOperation<T> writeOperation;

    private WriteTransaction(MappedTable<T> mappedTable, TransactableWriteOperation<T> writeOperation) {
        this.mappedTable = mappedTable;
        this.writeOperation = writeOperation;
    }

    public static <T> WriteTransaction<T> of(MappedTable<T> mappedTable, TransactableWriteOperation<T> writeOperation) {
        return new WriteTransaction<T>(mappedTable, writeOperation);
    }

    public MappedTable<T> mappedTable() {
        return this.mappedTable;
    }

    public TransactableWriteOperation<T> writeOperation() {
        return this.writeOperation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteTransaction that = (WriteTransaction)o;
        if (this.mappedTable != null ? !this.mappedTable.equals(that.mappedTable) : that.mappedTable != null) {
            return false;
        }
        return this.writeOperation != null ? this.writeOperation.equals(that.writeOperation) : that.writeOperation == null;
    }

    public int hashCode() {
        int result = this.mappedTable != null ? this.mappedTable.hashCode() : 0;
        result = 31 * result + (this.writeOperation != null ? this.writeOperation.hashCode() : 0);
        return result;
    }

    TransactWriteItem generateRequest() {
        return this.writeOperation.generateTransactWriteItem(this.mappedTable.tableSchema(), OperationContext.of(this.mappedTable.tableName()), this.mappedTable.mapperExtension());
    }
}

