/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dsql.model.ClusterArnListCopier;
import software.amazon.awssdk.services.dsql.model.DsqlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMultiRegionClustersResponse
extends DsqlResponse
implements ToCopyableBuilder<Builder, CreateMultiRegionClustersResponse> {
    private static final SdkField<List<String>> LINKED_CLUSTER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("linkedClusterArns").getter(CreateMultiRegionClustersResponse.getter(CreateMultiRegionClustersResponse::linkedClusterArns)).setter(CreateMultiRegionClustersResponse.setter(Builder::linkedClusterArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkedClusterArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINKED_CLUSTER_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("linkedClusterArns", LINKED_CLUSTER_ARNS_FIELD);
        }
    });
    private final List<String> linkedClusterArns;

    private CreateMultiRegionClustersResponse(BuilderImpl builder) {
        super(builder);
        this.linkedClusterArns = builder.linkedClusterArns;
    }

    public final boolean hasLinkedClusterArns() {
        return this.linkedClusterArns != null && !(this.linkedClusterArns instanceof SdkAutoConstructList);
    }

    public final List<String> linkedClusterArns() {
        return this.linkedClusterArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkedClusterArns() ? this.linkedClusterArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiRegionClustersResponse)) {
            return false;
        }
        CreateMultiRegionClustersResponse other = (CreateMultiRegionClustersResponse)((Object)obj);
        return this.hasLinkedClusterArns() == other.hasLinkedClusterArns() && Objects.equals(this.linkedClusterArns(), other.linkedClusterArns());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMultiRegionClustersResponse").add("LinkedClusterArns", this.hasLinkedClusterArns() ? this.linkedClusterArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "linkedClusterArns": {
                return Optional.ofNullable(clazz.cast(this.linkedClusterArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateMultiRegionClustersResponse, T> g) {
        return obj -> g.apply((CreateMultiRegionClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DsqlResponse.BuilderImpl
    implements Builder {
        private List<String> linkedClusterArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultiRegionClustersResponse model) {
            super(model);
            this.linkedClusterArns(model.linkedClusterArns);
        }

        public final Collection<String> getLinkedClusterArns() {
            if (this.linkedClusterArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.linkedClusterArns;
        }

        public final void setLinkedClusterArns(Collection<String> linkedClusterArns) {
            this.linkedClusterArns = ClusterArnListCopier.copy(linkedClusterArns);
        }

        @Override
        public final Builder linkedClusterArns(Collection<String> linkedClusterArns) {
            this.linkedClusterArns = ClusterArnListCopier.copy(linkedClusterArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedClusterArns(String ... linkedClusterArns) {
            this.linkedClusterArns(Arrays.asList(linkedClusterArns));
            return this;
        }

        @Override
        public CreateMultiRegionClustersResponse build() {
            return new CreateMultiRegionClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DsqlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMultiRegionClustersResponse> {
        public Builder linkedClusterArns(Collection<String> var1);

        public Builder linkedClusterArns(String ... var1);
    }
}

