/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.drs.model.LaunchActionCategory;
import software.amazon.awssdk.services.drs.model.LaunchActionParameter;
import software.amazon.awssdk.services.drs.model.LaunchActionParametersCopier;
import software.amazon.awssdk.services.drs.model.LaunchActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchAction> {
    private static final SdkField<String> ACTION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionCode").getter(LaunchAction.getter(LaunchAction::actionCode)).setter(LaunchAction.setter(Builder::actionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionCode").build()}).build();
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionId").getter(LaunchAction.getter(LaunchAction::actionId)).setter(LaunchAction.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()}).build();
    private static final SdkField<String> ACTION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionVersion").getter(LaunchAction.getter(LaunchAction::actionVersion)).setter(LaunchAction.setter(Builder::actionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionVersion").build()}).build();
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("active").getter(LaunchAction.getter(LaunchAction::active)).setter(LaunchAction.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("category").getter(LaunchAction.getter(LaunchAction::categoryAsString)).setter(LaunchAction.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(LaunchAction.getter(LaunchAction::description)).setter(LaunchAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(LaunchAction.getter(LaunchAction::name)).setter(LaunchAction.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> OPTIONAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("optional").getter(LaunchAction.getter(LaunchAction::optional)).setter(LaunchAction.setter(Builder::optional)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optional").build()}).build();
    private static final SdkField<Integer> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("order").getter(LaunchAction.getter(LaunchAction::order)).setter(LaunchAction.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()}).build();
    private static final SdkField<Map<String, LaunchActionParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(LaunchAction.getter(LaunchAction::parameters)).setter(LaunchAction.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchActionParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(LaunchAction.getter(LaunchAction::typeAsString)).setter(LaunchAction.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_CODE_FIELD, ACTION_ID_FIELD, ACTION_VERSION_FIELD, ACTIVE_FIELD, CATEGORY_FIELD, DESCRIPTION_FIELD, NAME_FIELD, OPTIONAL_FIELD, ORDER_FIELD, PARAMETERS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionCode;
    private final String actionId;
    private final String actionVersion;
    private final Boolean active;
    private final String category;
    private final String description;
    private final String name;
    private final Boolean optional;
    private final Integer order;
    private final Map<String, LaunchActionParameter> parameters;
    private final String type;

    private LaunchAction(BuilderImpl builder) {
        this.actionCode = builder.actionCode;
        this.actionId = builder.actionId;
        this.actionVersion = builder.actionVersion;
        this.active = builder.active;
        this.category = builder.category;
        this.description = builder.description;
        this.name = builder.name;
        this.optional = builder.optional;
        this.order = builder.order;
        this.parameters = builder.parameters;
        this.type = builder.type;
    }

    public final String actionCode() {
        return this.actionCode;
    }

    public final String actionId() {
        return this.actionId;
    }

    public final String actionVersion() {
        return this.actionVersion;
    }

    public final Boolean active() {
        return this.active;
    }

    public final LaunchActionCategory category() {
        return LaunchActionCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean optional() {
        return this.optional;
    }

    public final Integer order() {
        return this.order;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, LaunchActionParameter> parameters() {
        return this.parameters;
    }

    public final LaunchActionType type() {
        return LaunchActionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.optional());
        hashCode = 31 * hashCode + Objects.hashCode(this.order());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchAction)) {
            return false;
        }
        LaunchAction other = (LaunchAction)obj;
        return Objects.equals(this.actionCode(), other.actionCode()) && Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.actionVersion(), other.actionVersion()) && Objects.equals(this.active(), other.active()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.optional(), other.optional()) && Objects.equals(this.order(), other.order()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchAction").add("ActionCode", (Object)this.actionCode()).add("ActionId", (Object)this.actionId()).add("ActionVersion", (Object)this.actionVersion()).add("Active", (Object)this.active()).add("Category", (Object)this.categoryAsString()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("Optional", (Object)this.optional()).add("Order", (Object)this.order()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionCode": {
                return Optional.ofNullable(clazz.cast(this.actionCode()));
            }
            case "actionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "actionVersion": {
                return Optional.ofNullable(clazz.cast(this.actionVersion()));
            }
            case "active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "optional": {
                return Optional.ofNullable(clazz.cast(this.optional()));
            }
            case "order": {
                return Optional.ofNullable(clazz.cast(this.order()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionCode", ACTION_CODE_FIELD);
        map.put("actionId", ACTION_ID_FIELD);
        map.put("actionVersion", ACTION_VERSION_FIELD);
        map.put("active", ACTIVE_FIELD);
        map.put("category", CATEGORY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("optional", OPTIONAL_FIELD);
        map.put("order", ORDER_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchAction, T> g) {
        return obj -> g.apply((LaunchAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionCode;
        private String actionId;
        private String actionVersion;
        private Boolean active;
        private String category;
        private String description;
        private String name;
        private Boolean optional;
        private Integer order;
        private Map<String, LaunchActionParameter> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchAction model) {
            this.actionCode(model.actionCode);
            this.actionId(model.actionId);
            this.actionVersion(model.actionVersion);
            this.active(model.active);
            this.category(model.category);
            this.description(model.description);
            this.name(model.name);
            this.optional(model.optional);
            this.order(model.order);
            this.parameters(model.parameters);
            this.type(model.type);
        }

        public final String getActionCode() {
            return this.actionCode;
        }

        public final void setActionCode(String actionCode) {
            this.actionCode = actionCode;
        }

        @Override
        public final Builder actionCode(String actionCode) {
            this.actionCode = actionCode;
            return this;
        }

        public final String getActionId() {
            return this.actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getActionVersion() {
            return this.actionVersion;
        }

        public final void setActionVersion(String actionVersion) {
            this.actionVersion = actionVersion;
        }

        @Override
        public final Builder actionVersion(String actionVersion) {
            this.actionVersion = actionVersion;
            return this;
        }

        public final Boolean getActive() {
            return this.active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(LaunchActionCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getOptional() {
            return this.optional;
        }

        public final void setOptional(Boolean optional) {
            this.optional = optional;
        }

        @Override
        public final Builder optional(Boolean optional) {
            this.optional = optional;
            return this;
        }

        public final Integer getOrder() {
            return this.order;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final Map<String, LaunchActionParameter.Builder> getParameters() {
            Map<String, LaunchActionParameter.Builder> result = LaunchActionParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, LaunchActionParameter.BuilderImpl> parameters) {
            this.parameters = LaunchActionParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, LaunchActionParameter> parameters) {
            this.parameters = LaunchActionParametersCopier.copy(parameters);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LaunchActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public LaunchAction build() {
            return new LaunchAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchAction> {
        public Builder actionCode(String var1);

        public Builder actionId(String var1);

        public Builder actionVersion(String var1);

        public Builder active(Boolean var1);

        public Builder category(String var1);

        public Builder category(LaunchActionCategory var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder optional(Boolean var1);

        public Builder order(Integer var1);

        public Builder parameters(Map<String, LaunchActionParameter> var1);

        public Builder type(String var1);

        public Builder type(LaunchActionType var1);
    }
}

