/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.drs.model.DrsResponse;
import software.amazon.awssdk.services.drs.model.LaunchDisposition;
import software.amazon.awssdk.services.drs.model.LaunchIntoInstanceProperties;
import software.amazon.awssdk.services.drs.model.Licensing;
import software.amazon.awssdk.services.drs.model.TargetInstanceTypeRightSizingMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLaunchConfigurationResponse
extends DrsResponse
implements ToCopyableBuilder<Builder, GetLaunchConfigurationResponse> {
    private static final SdkField<Boolean> COPY_PRIVATE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("copyPrivateIp").getter(GetLaunchConfigurationResponse.getter(GetLaunchConfigurationResponse::copyPrivateIp)).setter(GetLaunchConfigurationResponse.setter(Builder::copyPrivateIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyPrivateIp").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("copyTags").getter(GetLaunchConfigurationResponse.getter(GetLaunchConfigurationResponse::copyTags)).setter(GetLaunchConfigurationResponse.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTags").build()}).build();
    private static final SdkField<String> EC2_LAUNCH_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2LaunchTemplateID").getter(GetLaunchConfigurationResponse.getter(GetLaunchConfigurationResponse::ec2LaunchTemplateID)).setter(GetLaunchConfigurationResponse.setter(Builder::ec2LaunchTemplateID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2LaunchTemplateID").build()}).build();
    private static final SdkField<String> LAUNCH_DISPOSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchDisposition").getter(GetLaunchConfigurationResponse.getter(GetLaunchConfigurationResponse::launchDispositionAsString)).setter(GetLaunchConfigurationResponse.setter(Builder::launchDisposition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDisposition").build()}).build();
    private static final SdkField<LaunchIntoInstanceProperties> LAUNCH_INTO_INSTANCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchIntoInstanceProperties").getter(GetLaunchConfigurationResponse.getter(GetLaunchConfigurationResponse::launchIntoInstanceProperties)).setter(GetLaunchConfigurationResponse.setter(Builder::launchIntoInstanceProperties)).constructor(LaunchIntoInstanceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchIntoInstanceProperties").build()}).build();
    private static final SdkField<Licensing> LICENSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("licensing").getter(GetLaunchConfigurationResponse.getter(GetLaunchConfigurationResponse::licensing)).setter(GetLaunchConfigurationResponse.setter(Builder::licensing)).constructor(Licensing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licensing").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetLaunchConfigurationResponse.getter(GetLaunchConfigurationResponse::name)).setter(GetLaunchConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> POST_LAUNCH_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("postLaunchEnabled").getter(GetLaunchConfigurationResponse.getter(GetLaunchConfigurationResponse::postLaunchEnabled)).setter(GetLaunchConfigurationResponse.setter(Builder::postLaunchEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postLaunchEnabled").build()}).build();
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(GetLaunchConfigurationResponse.getter(GetLaunchConfigurationResponse::sourceServerID)).setter(GetLaunchConfigurationResponse.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final SdkField<String> TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetInstanceTypeRightSizingMethod").getter(GetLaunchConfigurationResponse.getter(GetLaunchConfigurationResponse::targetInstanceTypeRightSizingMethodAsString)).setter(GetLaunchConfigurationResponse.setter(Builder::targetInstanceTypeRightSizingMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstanceTypeRightSizingMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_PRIVATE_IP_FIELD, COPY_TAGS_FIELD, EC2_LAUNCH_TEMPLATE_ID_FIELD, LAUNCH_DISPOSITION_FIELD, LAUNCH_INTO_INSTANCE_PROPERTIES_FIELD, LICENSING_FIELD, NAME_FIELD, POST_LAUNCH_ENABLED_FIELD, SOURCE_SERVER_ID_FIELD, TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLaunchConfigurationResponse.memberNameToFieldInitializer();
    private final Boolean copyPrivateIp;
    private final Boolean copyTags;
    private final String ec2LaunchTemplateID;
    private final String launchDisposition;
    private final LaunchIntoInstanceProperties launchIntoInstanceProperties;
    private final Licensing licensing;
    private final String name;
    private final Boolean postLaunchEnabled;
    private final String sourceServerID;
    private final String targetInstanceTypeRightSizingMethod;

    private GetLaunchConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.copyPrivateIp = builder.copyPrivateIp;
        this.copyTags = builder.copyTags;
        this.ec2LaunchTemplateID = builder.ec2LaunchTemplateID;
        this.launchDisposition = builder.launchDisposition;
        this.launchIntoInstanceProperties = builder.launchIntoInstanceProperties;
        this.licensing = builder.licensing;
        this.name = builder.name;
        this.postLaunchEnabled = builder.postLaunchEnabled;
        this.sourceServerID = builder.sourceServerID;
        this.targetInstanceTypeRightSizingMethod = builder.targetInstanceTypeRightSizingMethod;
    }

    public final Boolean copyPrivateIp() {
        return this.copyPrivateIp;
    }

    public final Boolean copyTags() {
        return this.copyTags;
    }

    public final String ec2LaunchTemplateID() {
        return this.ec2LaunchTemplateID;
    }

    public final LaunchDisposition launchDisposition() {
        return LaunchDisposition.fromValue(this.launchDisposition);
    }

    public final String launchDispositionAsString() {
        return this.launchDisposition;
    }

    public final LaunchIntoInstanceProperties launchIntoInstanceProperties() {
        return this.launchIntoInstanceProperties;
    }

    public final Licensing licensing() {
        return this.licensing;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean postLaunchEnabled() {
        return this.postLaunchEnabled;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    public final TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod() {
        return TargetInstanceTypeRightSizingMethod.fromValue(this.targetInstanceTypeRightSizingMethod);
    }

    public final String targetInstanceTypeRightSizingMethodAsString() {
        return this.targetInstanceTypeRightSizingMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.copyPrivateIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2LaunchTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchIntoInstanceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.licensing());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.postLaunchEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetInstanceTypeRightSizingMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLaunchConfigurationResponse)) {
            return false;
        }
        GetLaunchConfigurationResponse other = (GetLaunchConfigurationResponse)((Object)obj);
        return Objects.equals(this.copyPrivateIp(), other.copyPrivateIp()) && Objects.equals(this.copyTags(), other.copyTags()) && Objects.equals(this.ec2LaunchTemplateID(), other.ec2LaunchTemplateID()) && Objects.equals(this.launchDispositionAsString(), other.launchDispositionAsString()) && Objects.equals(this.launchIntoInstanceProperties(), other.launchIntoInstanceProperties()) && Objects.equals(this.licensing(), other.licensing()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.postLaunchEnabled(), other.postLaunchEnabled()) && Objects.equals(this.sourceServerID(), other.sourceServerID()) && Objects.equals(this.targetInstanceTypeRightSizingMethodAsString(), other.targetInstanceTypeRightSizingMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetLaunchConfigurationResponse").add("CopyPrivateIp", (Object)this.copyPrivateIp()).add("CopyTags", (Object)this.copyTags()).add("Ec2LaunchTemplateID", (Object)this.ec2LaunchTemplateID()).add("LaunchDisposition", (Object)this.launchDispositionAsString()).add("LaunchIntoInstanceProperties", (Object)this.launchIntoInstanceProperties()).add("Licensing", (Object)this.licensing()).add("Name", (Object)this.name()).add("PostLaunchEnabled", (Object)this.postLaunchEnabled()).add("SourceServerID", (Object)this.sourceServerID()).add("TargetInstanceTypeRightSizingMethod", (Object)this.targetInstanceTypeRightSizingMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "copyPrivateIp": {
                return Optional.ofNullable(clazz.cast(this.copyPrivateIp()));
            }
            case "copyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "ec2LaunchTemplateID": {
                return Optional.ofNullable(clazz.cast(this.ec2LaunchTemplateID()));
            }
            case "launchDisposition": {
                return Optional.ofNullable(clazz.cast(this.launchDispositionAsString()));
            }
            case "launchIntoInstanceProperties": {
                return Optional.ofNullable(clazz.cast(this.launchIntoInstanceProperties()));
            }
            case "licensing": {
                return Optional.ofNullable(clazz.cast(this.licensing()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "postLaunchEnabled": {
                return Optional.ofNullable(clazz.cast(this.postLaunchEnabled()));
            }
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
            case "targetInstanceTypeRightSizingMethod": {
                return Optional.ofNullable(clazz.cast(this.targetInstanceTypeRightSizingMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("copyPrivateIp", COPY_PRIVATE_IP_FIELD);
        map.put("copyTags", COPY_TAGS_FIELD);
        map.put("ec2LaunchTemplateID", EC2_LAUNCH_TEMPLATE_ID_FIELD);
        map.put("launchDisposition", LAUNCH_DISPOSITION_FIELD);
        map.put("launchIntoInstanceProperties", LAUNCH_INTO_INSTANCE_PROPERTIES_FIELD);
        map.put("licensing", LICENSING_FIELD);
        map.put("name", NAME_FIELD);
        map.put("postLaunchEnabled", POST_LAUNCH_ENABLED_FIELD);
        map.put("sourceServerID", SOURCE_SERVER_ID_FIELD);
        map.put("targetInstanceTypeRightSizingMethod", TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLaunchConfigurationResponse, T> g) {
        return obj -> g.apply((GetLaunchConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DrsResponse.BuilderImpl
    implements Builder {
        private Boolean copyPrivateIp;
        private Boolean copyTags;
        private String ec2LaunchTemplateID;
        private String launchDisposition;
        private LaunchIntoInstanceProperties launchIntoInstanceProperties;
        private Licensing licensing;
        private String name;
        private Boolean postLaunchEnabled;
        private String sourceServerID;
        private String targetInstanceTypeRightSizingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLaunchConfigurationResponse model) {
            super(model);
            this.copyPrivateIp(model.copyPrivateIp);
            this.copyTags(model.copyTags);
            this.ec2LaunchTemplateID(model.ec2LaunchTemplateID);
            this.launchDisposition(model.launchDisposition);
            this.launchIntoInstanceProperties(model.launchIntoInstanceProperties);
            this.licensing(model.licensing);
            this.name(model.name);
            this.postLaunchEnabled(model.postLaunchEnabled);
            this.sourceServerID(model.sourceServerID);
            this.targetInstanceTypeRightSizingMethod(model.targetInstanceTypeRightSizingMethod);
        }

        public final Boolean getCopyPrivateIp() {
            return this.copyPrivateIp;
        }

        public final void setCopyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
        }

        @Override
        public final Builder copyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
            return this;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final String getEc2LaunchTemplateID() {
            return this.ec2LaunchTemplateID;
        }

        public final void setEc2LaunchTemplateID(String ec2LaunchTemplateID) {
            this.ec2LaunchTemplateID = ec2LaunchTemplateID;
        }

        @Override
        public final Builder ec2LaunchTemplateID(String ec2LaunchTemplateID) {
            this.ec2LaunchTemplateID = ec2LaunchTemplateID;
            return this;
        }

        public final String getLaunchDisposition() {
            return this.launchDisposition;
        }

        public final void setLaunchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
        }

        @Override
        public final Builder launchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
            return this;
        }

        @Override
        public final Builder launchDisposition(LaunchDisposition launchDisposition) {
            this.launchDisposition(launchDisposition == null ? null : launchDisposition.toString());
            return this;
        }

        public final LaunchIntoInstanceProperties.Builder getLaunchIntoInstanceProperties() {
            return this.launchIntoInstanceProperties != null ? this.launchIntoInstanceProperties.toBuilder() : null;
        }

        public final void setLaunchIntoInstanceProperties(LaunchIntoInstanceProperties.BuilderImpl launchIntoInstanceProperties) {
            this.launchIntoInstanceProperties = launchIntoInstanceProperties != null ? launchIntoInstanceProperties.build() : null;
        }

        @Override
        public final Builder launchIntoInstanceProperties(LaunchIntoInstanceProperties launchIntoInstanceProperties) {
            this.launchIntoInstanceProperties = launchIntoInstanceProperties;
            return this;
        }

        public final Licensing.Builder getLicensing() {
            return this.licensing != null ? this.licensing.toBuilder() : null;
        }

        public final void setLicensing(Licensing.BuilderImpl licensing) {
            this.licensing = licensing != null ? licensing.build() : null;
        }

        @Override
        public final Builder licensing(Licensing licensing) {
            this.licensing = licensing;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getPostLaunchEnabled() {
            return this.postLaunchEnabled;
        }

        public final void setPostLaunchEnabled(Boolean postLaunchEnabled) {
            this.postLaunchEnabled = postLaunchEnabled;
        }

        @Override
        public final Builder postLaunchEnabled(Boolean postLaunchEnabled) {
            this.postLaunchEnabled = postLaunchEnabled;
            return this;
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final String getTargetInstanceTypeRightSizingMethod() {
            return this.targetInstanceTypeRightSizingMethod;
        }

        public final void setTargetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
            return this;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod(targetInstanceTypeRightSizingMethod == null ? null : targetInstanceTypeRightSizingMethod.toString());
            return this;
        }

        @Override
        public GetLaunchConfigurationResponse build() {
            return new GetLaunchConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DrsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLaunchConfigurationResponse> {
        public Builder copyPrivateIp(Boolean var1);

        public Builder copyTags(Boolean var1);

        public Builder ec2LaunchTemplateID(String var1);

        public Builder launchDisposition(String var1);

        public Builder launchDisposition(LaunchDisposition var1);

        public Builder launchIntoInstanceProperties(LaunchIntoInstanceProperties var1);

        default public Builder launchIntoInstanceProperties(Consumer<LaunchIntoInstanceProperties.Builder> launchIntoInstanceProperties) {
            return this.launchIntoInstanceProperties((LaunchIntoInstanceProperties)((LaunchIntoInstanceProperties.Builder)LaunchIntoInstanceProperties.builder().applyMutation(launchIntoInstanceProperties)).build());
        }

        public Builder licensing(Licensing var1);

        default public Builder licensing(Consumer<Licensing.Builder> licensing) {
            return this.licensing((Licensing)((Licensing.Builder)Licensing.builder().applyMutation(licensing)).build());
        }

        public Builder name(String var1);

        public Builder postLaunchEnabled(Boolean var1);

        public Builder sourceServerID(String var1);

        public Builder targetInstanceTypeRightSizingMethod(String var1);

        public Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod var1);
    }
}

