/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.drs.model.LaunchAction;
import software.amazon.awssdk.services.drs.model.LaunchActionRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchActionRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchActionRun> {
    private static final SdkField<LaunchAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("action").getter(LaunchActionRun.getter(LaunchActionRun::action)).setter(LaunchActionRun.setter(Builder::action)).constructor(LaunchAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(LaunchActionRun.getter(LaunchActionRun::failureReason)).setter(LaunchActionRun.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runId").getter(LaunchActionRun.getter(LaunchActionRun::runId)).setter(LaunchActionRun.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(LaunchActionRun.getter(LaunchActionRun::statusAsString)).setter(LaunchActionRun.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, FAILURE_REASON_FIELD, RUN_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchActionRun.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LaunchAction action;
    private final String failureReason;
    private final String runId;
    private final String status;

    private LaunchActionRun(BuilderImpl builder) {
        this.action = builder.action;
        this.failureReason = builder.failureReason;
        this.runId = builder.runId;
        this.status = builder.status;
    }

    public final LaunchAction action() {
        return this.action;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String runId() {
        return this.runId;
    }

    public final LaunchActionRunStatus status() {
        return LaunchActionRunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchActionRun)) {
            return false;
        }
        LaunchActionRun other = (LaunchActionRun)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchActionRun").add("Action", (Object)this.action()).add("FailureReason", (Object)this.failureReason()).add("RunId", (Object)this.runId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "runId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("action", ACTION_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("runId", RUN_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchActionRun, T> g) {
        return obj -> g.apply((LaunchActionRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LaunchAction action;
        private String failureReason;
        private String runId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchActionRun model) {
            this.action(model.action);
            this.failureReason(model.failureReason);
            this.runId(model.runId);
            this.status(model.status);
        }

        public final LaunchAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(LaunchAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(LaunchAction action) {
            this.action = action;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LaunchActionRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public LaunchActionRun build() {
            return new LaunchActionRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchActionRun> {
        public Builder action(LaunchAction var1);

        default public Builder action(Consumer<LaunchAction.Builder> action) {
            return this.action((LaunchAction)((LaunchAction.Builder)LaunchAction.builder().applyMutation(action)).build());
        }

        public Builder failureReason(String var1);

        public Builder runId(String var1);

        public Builder status(String var1);

        public Builder status(LaunchActionRunStatus var1);
    }
}

