/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsClient;
import software.amazon.awssdk.services.drs.internal.UserAgentUtils;
import software.amazon.awssdk.services.drs.model.DescribeSourceServersRequest;
import software.amazon.awssdk.services.drs.model.DescribeSourceServersResponse;
import software.amazon.awssdk.services.drs.model.SourceServer;

public class DescribeSourceServersIterable
implements SdkIterable<DescribeSourceServersResponse> {
    private final DrsClient client;
    private final DescribeSourceServersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSourceServersIterable(DrsClient client, DescribeSourceServersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSourceServersResponseFetcher();
    }

    public Iterator<DescribeSourceServersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SourceServer> items() {
        Function<DescribeSourceServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSourceServersResponseFetcher
    implements SyncPageFetcher<DescribeSourceServersResponse> {
        private DescribeSourceServersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSourceServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSourceServersResponse nextPage(DescribeSourceServersResponse previousPage) {
            if (previousPage == null) {
                return DescribeSourceServersIterable.this.client.describeSourceServers(DescribeSourceServersIterable.this.firstRequest);
            }
            return DescribeSourceServersIterable.this.client.describeSourceServers((DescribeSourceServersRequest)((Object)DescribeSourceServersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

