/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.drs.model.DrsRequest;
import software.amazon.awssdk.services.drs.model.StartRecoveryRequestSourceServer;
import software.amazon.awssdk.services.drs.model.StartRecoveryRequestSourceServersCopier;
import software.amazon.awssdk.services.drs.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartRecoveryRequest
extends DrsRequest
implements ToCopyableBuilder<Builder, StartRecoveryRequest> {
    private static final SdkField<Boolean> IS_DRILL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isDrill").getter(StartRecoveryRequest.getter(StartRecoveryRequest::isDrill)).setter(StartRecoveryRequest.setter(Builder::isDrill)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDrill").build()}).build();
    private static final SdkField<List<StartRecoveryRequestSourceServer>> SOURCE_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceServers").getter(StartRecoveryRequest.getter(StartRecoveryRequest::sourceServers)).setter(StartRecoveryRequest.setter(Builder::sourceServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StartRecoveryRequestSourceServer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartRecoveryRequest.getter(StartRecoveryRequest::tags)).setter(StartRecoveryRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_DRILL_FIELD, SOURCE_SERVERS_FIELD, TAGS_FIELD));
    private final Boolean isDrill;
    private final List<StartRecoveryRequestSourceServer> sourceServers;
    private final Map<String, String> tags;

    private StartRecoveryRequest(BuilderImpl builder) {
        super(builder);
        this.isDrill = builder.isDrill;
        this.sourceServers = builder.sourceServers;
        this.tags = builder.tags;
    }

    public final Boolean isDrill() {
        return this.isDrill;
    }

    public final boolean hasSourceServers() {
        return this.sourceServers != null && !(this.sourceServers instanceof SdkAutoConstructList);
    }

    public final List<StartRecoveryRequestSourceServer> sourceServers() {
        return this.sourceServers;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.isDrill());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceServers() ? this.sourceServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRecoveryRequest)) {
            return false;
        }
        StartRecoveryRequest other = (StartRecoveryRequest)((Object)obj);
        return Objects.equals(this.isDrill(), other.isDrill()) && this.hasSourceServers() == other.hasSourceServers() && Objects.equals(this.sourceServers(), other.sourceServers()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartRecoveryRequest").add("IsDrill", (Object)this.isDrill()).add("SourceServers", this.hasSourceServers() ? this.sourceServers() : null).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isDrill": {
                return Optional.ofNullable(clazz.cast(this.isDrill()));
            }
            case "sourceServers": {
                return Optional.ofNullable(clazz.cast(this.sourceServers()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartRecoveryRequest, T> g) {
        return obj -> g.apply((StartRecoveryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DrsRequest.BuilderImpl
    implements Builder {
        private Boolean isDrill;
        private List<StartRecoveryRequestSourceServer> sourceServers = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartRecoveryRequest model) {
            super(model);
            this.isDrill(model.isDrill);
            this.sourceServers(model.sourceServers);
            this.tags(model.tags);
        }

        public final Boolean getIsDrill() {
            return this.isDrill;
        }

        public final void setIsDrill(Boolean isDrill) {
            this.isDrill = isDrill;
        }

        @Override
        public final Builder isDrill(Boolean isDrill) {
            this.isDrill = isDrill;
            return this;
        }

        public final List<StartRecoveryRequestSourceServer.Builder> getSourceServers() {
            List<StartRecoveryRequestSourceServer.Builder> result = StartRecoveryRequestSourceServersCopier.copyToBuilder(this.sourceServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceServers(Collection<StartRecoveryRequestSourceServer.BuilderImpl> sourceServers) {
            this.sourceServers = StartRecoveryRequestSourceServersCopier.copyFromBuilder(sourceServers);
        }

        @Override
        public final Builder sourceServers(Collection<StartRecoveryRequestSourceServer> sourceServers) {
            this.sourceServers = StartRecoveryRequestSourceServersCopier.copy(sourceServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServers(StartRecoveryRequestSourceServer ... sourceServers) {
            this.sourceServers(Arrays.asList(sourceServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServers(Consumer<StartRecoveryRequestSourceServer.Builder> ... sourceServers) {
            this.sourceServers(Stream.of(sourceServers).map(c -> (StartRecoveryRequestSourceServer)((StartRecoveryRequestSourceServer.Builder)StartRecoveryRequestSourceServer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRecoveryRequest build() {
            return new StartRecoveryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DrsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartRecoveryRequest> {
        public Builder isDrill(Boolean var1);

        public Builder sourceServers(Collection<StartRecoveryRequestSourceServer> var1);

        public Builder sourceServers(StartRecoveryRequestSourceServer ... var1);

        public Builder sourceServers(Consumer<StartRecoveryRequestSourceServer.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

